/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.JumpInstruction;

public class GotoInstruction
extends JumpInstruction {
    GotoInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public int getStackChange() {
        if (this.getOpcode() == 168) {
            return 1;
        }
        return 0;
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                return super.getLength() + 4;
            }
        }
        return super.getLength() + 2;
    }

    public void setOffset(int offset) {
        super.setOffset(offset);
        this.calculateOpcode();
    }

    private void calculateOpcode() {
        int len = this.getLength();
        switch (this.getOpcode()) {
            case 167: 
            case 200: {
                int offset = this.getOffset();
                if (offset < 131072) {
                    this.setOpcode(167);
                    break;
                }
                this.setOpcode(200);
                break;
            }
            case 168: 
            case 201: {
                int offset = this.getOffset();
                if (offset < 131072) {
                    this.setOpcode(168);
                    break;
                }
                this.setOpcode(201);
            }
        }
        if (len != this.getLength()) {
            this.invalidateByteIndexes();
        }
    }
}

