/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NewBenchmarkSpec {
    private final String className;
    private final String methodName;
    private final ImmutableMap<String, String> parameters;

    private NewBenchmarkSpec(Builder builder) {
        this.className = builder.className;
        this.methodName = builder.methodName;
        this.parameters = builder.parametersBuilder.build();
    }

    public String className() {
        return this.className;
    }

    public String methodName() {
        return this.methodName;
    }

    public ImmutableMap<String, String> parameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NewBenchmarkSpec) {
            NewBenchmarkSpec that = (NewBenchmarkSpec)obj;
            return this.className.equals(that.className) && this.methodName.equals(that.methodName) && this.parameters.equals(this.parameters);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.className, this.methodName, this.parameters});
    }

    public static final class Builder {
        private String className;
        private String methodName;
        private final ImmutableMap.Builder<String, String> parametersBuilder = ImmutableMap.builder();

        public Builder className(String className) {
            this.className = (String)Preconditions.checkNotNull((Object)className);
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
            return this;
        }

        public Builder addParameter(String parameterName, String value) {
            this.parametersBuilder.put(Preconditions.checkNotNull((Object)parameterName), Preconditions.checkNotNull((Object)value));
            return this;
        }

        public Builder addAllParameters(Map<String, String> parameters) {
            this.parametersBuilder.putAll(parameters);
            return this;
        }

        public NewBenchmarkSpec build() {
            Preconditions.checkState((this.className != null ? 1 : 0) != 0);
            Preconditions.checkState((this.methodName != null ? 1 : 0) != 0);
            return new NewBenchmarkSpec(this);
        }
    }
}

