/*
 * Decompiled with CFR 0.152.
 */
package tcl.regex;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class OroRegsubCmd
implements Command {
    private static final int OPT_ALL = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;
    private static final String[] validCmds = new String[]{"-all", "-nocase", "--"};

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int objc = argv.length - 1;
        boolean noCase = false;
        boolean all = false;
        boolean last = false;
        if (argv.length >= 3) {
            int currentObjIndex = 1;
            while (objc > 0 && !last && argv[currentObjIndex].toString().startsWith("-")) {
                int opt = TclIndex.get((Interp)interp, (TclObject)argv[currentObjIndex], (String[])validCmds, (String)"switch", (int)1);
                switch (opt) {
                    default: {
                        throw new TclException(interp, "RegsubCmd.cmdProc: bad option " + opt + " index to cmds");
                    }
                    case 0: {
                        all = true;
                        break;
                    }
                    case 1: {
                        noCase = true;
                        break;
                    }
                    case 2: {
                        last = true;
                        break;
                    }
                }
                ++currentObjIndex;
                --objc;
            }
            if (objc == 4) {
                Pattern pattern1;
                String origStringArg;
                String patternArg = argv[currentObjIndex].toString();
                String stringArg = origStringArg = argv[currentObjIndex + 1].toString();
                String subSpec = argv[currentObjIndex + 2].toString();
                String varName = argv[currentObjIndex + 3].toString();
                if (noCase) {
                    patternArg = patternArg.toLowerCase();
                    stringArg = origStringArg.toLowerCase();
                }
                Perl5Matcher L14 = new Perl5Matcher();
                Perl5Compiler L15 = new Perl5Compiler();
                try {
                    Perl5Compiler compiler = L15;
                    pattern1 = compiler.compile(patternArg);
                }
                catch (MalformedPatternException e) {
                    String msg = e.getMessage().equals("Unmatched parentheses.") ? "unmatched ()" : e.getMessage();
                    throw new TclException(interp, "couldn't compile regular expression pattern: " + msg);
                }
                PatternMatcherInput input = new PatternMatcherInput(stringArg);
                StringBuffer sbuf = new StringBuffer(0);
                int numMatches = 0;
                int unmatchedIndex = 0;
                while (L14.contains(input, pattern1)) {
                    ++numMatches;
                    MatchResult result = L14.getMatch();
                    String tmp = origStringArg.substring(unmatchedIndex, result.beginOffset(0));
                    unmatchedIndex = result.endOffset(0);
                    sbuf.ensureCapacity(sbuf.length() + tmp.length());
                    sbuf.append(tmp);
                    int group = -1;
                    int nextSpecIndex = -1;
                    int first = 0;
                    while (first < subSpec.length()) {
                        int c;
                        int specIndex = first;
                        while (specIndex < subSpec.length()) {
                            c = subSpec.charAt(specIndex);
                            if (c == 38) {
                                group = 0;
                                nextSpecIndex = specIndex + 1;
                                break;
                            }
                            if (c == 92 && specIndex + 1 < subSpec.length()) {
                                c = subSpec.charAt(specIndex + 1);
                                if (!Character.isDigit((char)c)) {
                                    sbuf.ensureCapacity(sbuf.length() + (specIndex - first) + 1);
                                    sbuf.append(String.valueOf(subSpec.substring(first, specIndex)) + (char)c);
                                    first = specIndex + 2;
                                    ++specIndex;
                                } else {
                                    group = Character.digit((char)c, 10);
                                    if (group < result.groups()) {
                                        nextSpecIndex = specIndex + 2;
                                        break;
                                    }
                                    sbuf.ensureCapacity(sbuf.length() + (specIndex - first));
                                    sbuf.append(subSpec.substring(first, specIndex));
                                    first = specIndex + 2;
                                    ++specIndex;
                                }
                            }
                            ++specIndex;
                        }
                        if (specIndex >= subSpec.length()) {
                            sbuf.ensureCapacity(sbuf.length() + (specIndex - first));
                            sbuf.append(subSpec.substring(first));
                            break;
                        }
                        c = result.beginOffset(group);
                        tmp = c != -1 ? String.valueOf(subSpec.substring(first, specIndex)) + origStringArg.substring(c, result.endOffset(group)) : subSpec.substring(first, specIndex);
                        sbuf.ensureCapacity(tmp.length());
                        sbuf.append(tmp);
                        first = nextSpecIndex;
                    }
                    if (!all) break;
                }
                interp.setResult(numMatches);
                String value = numMatches == 0 ? origStringArg : (unmatchedIndex < origStringArg.length() ? String.valueOf(sbuf.toString()) + origStringArg.substring(unmatchedIndex) : sbuf.toString());
                try {
                    interp.setVar(varName, TclString.newInstance((String)value), 0);
                }
                catch (TclException TclException0) {
                    throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
                }
                return;
            }
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string subSpec varName");
        }
        throw new TclNumArgsException(interp, 1, argv, "?switches? exp string subSpec varName");
    }
}

