/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.AbsFunction;
import tcl.lang.AcosFunction;
import tcl.lang.AsinFunction;
import tcl.lang.Atan2Function;
import tcl.lang.AtanFunction;
import tcl.lang.CeilFunction;
import tcl.lang.CosFunction;
import tcl.lang.CoshFunction;
import tcl.lang.DoubleFunction;
import tcl.lang.ExpFunction;
import tcl.lang.ExprValue;
import tcl.lang.FloorFunction;
import tcl.lang.FmodFunction;
import tcl.lang.HypotFunction;
import tcl.lang.IntFunction;
import tcl.lang.Interp;
import tcl.lang.Log10Function;
import tcl.lang.LogFunction;
import tcl.lang.MathFunction;
import tcl.lang.ParseAdaptor;
import tcl.lang.ParseResult;
import tcl.lang.PowFunction;
import tcl.lang.RandFunction;
import tcl.lang.RoundFunction;
import tcl.lang.SinFunction;
import tcl.lang.SinhFunction;
import tcl.lang.SqrtFunction;
import tcl.lang.SrandFunction;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TanFunction;
import tcl.lang.TanhFunction;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class Expression {
    static final int VALUE = 0;
    static final int OPEN_PAREN = 1;
    static final int CLOSE_PAREN = 2;
    static final int COMMA = 3;
    static final int END = 4;
    static final int UNKNOWN = 5;
    static final int MULT = 8;
    static final int DIVIDE = 9;
    static final int MOD = 10;
    static final int PLUS = 11;
    static final int MINUS = 12;
    static final int LEFT_SHIFT = 13;
    static final int RIGHT_SHIFT = 14;
    static final int LESS = 15;
    static final int GREATER = 16;
    static final int LEQ = 17;
    static final int GEQ = 18;
    static final int EQUAL = 19;
    static final int NEQ = 20;
    static final int BIT_AND = 21;
    static final int BIT_XOR = 22;
    static final int BIT_OR = 23;
    static final int AND = 24;
    static final int OR = 25;
    static final int QUESTY = 26;
    static final int COLON = 27;
    static final int UNARY_MINUS = 28;
    static final int UNARY_PLUS = 29;
    static final int NOT = 30;
    static final int BIT_NOT = 31;
    static int[] precTable;
    static String[] operatorStrings;
    Hashtable mathFuncTable = new Hashtable();
    private String m_expr;
    private int m_len;
    int m_token;
    private int m_ind;

    TclObject eval(Interp interp, String string) throws TclException {
        ExprValue exprValue = this.ExprTopLevel(interp, string);
        switch (exprValue.type) {
            case 1: {
                return TclInteger.newInstance((int)exprValue.intValue);
            }
            case 2: {
                return TclDouble.newInstance(exprValue.doubleValue);
            }
            case 3: {
                return TclString.newInstance(exprValue.stringValue);
            }
        }
        throw new TclRuntimeError("internal error: expression, unknown");
    }

    boolean evalBoolean(Interp interp, String string) throws TclException {
        ExprValue exprValue = this.ExprTopLevel(interp, string);
        switch (exprValue.type) {
            case 1: {
                return exprValue.intValue != 0L;
            }
            case 2: {
                return exprValue.doubleValue != 0.0;
            }
            case 3: {
                return Util.getBoolean(interp, exprValue.stringValue);
            }
        }
        throw new TclRuntimeError("internal error: expression, unknown");
    }

    Expression() {
        this.mathFuncTable.put("atan2", new Atan2Function());
        this.mathFuncTable.put("pow", new PowFunction());
        this.mathFuncTable.put("acos", new AcosFunction());
        this.mathFuncTable.put("asin", new AsinFunction());
        this.mathFuncTable.put("atan", new AtanFunction());
        this.mathFuncTable.put("ceil", new CeilFunction());
        this.mathFuncTable.put("cos", new CosFunction());
        this.mathFuncTable.put("cosh", new CoshFunction());
        this.mathFuncTable.put("exp", new ExpFunction());
        this.mathFuncTable.put("floor", new FloorFunction());
        this.mathFuncTable.put("fmod", new FmodFunction());
        this.mathFuncTable.put("hypot", new HypotFunction());
        this.mathFuncTable.put("log", new LogFunction());
        this.mathFuncTable.put("log10", new Log10Function());
        this.mathFuncTable.put("rand", new RandFunction());
        this.mathFuncTable.put("sin", new SinFunction());
        this.mathFuncTable.put("sinh", new SinhFunction());
        this.mathFuncTable.put("sqrt", new SqrtFunction());
        this.mathFuncTable.put("srand", new SrandFunction());
        this.mathFuncTable.put("tan", new TanFunction());
        this.mathFuncTable.put("tanh", new TanhFunction());
        this.mathFuncTable.put("abs", new AbsFunction());
        this.mathFuncTable.put("double", new DoubleFunction());
        this.mathFuncTable.put("int", new IntFunction());
        this.mathFuncTable.put("round", new RoundFunction());
        this.m_expr = null;
        this.m_ind = 0;
        this.m_len = 0;
        this.m_token = 5;
    }

    private final ExprValue ExprTopLevel(Interp interp, String string) throws TclException {
        String string2 = this.m_expr;
        int n = this.m_len;
        int n2 = this.m_token;
        int n3 = this.m_ind;
        try {
            this.m_expr = string;
            this.m_ind = 0;
            this.m_len = string.length();
            this.m_token = 5;
            ExprValue exprValue = this.ExprGetValue(interp, -1);
            if (this.m_token != 4) {
                this.SyntaxError(interp);
            }
            ExprValue exprValue2 = exprValue;
            Object var9_9 = null;
            this.m_expr = string2;
            this.m_len = n;
            this.m_token = n2;
            this.m_ind = n3;
            return exprValue2;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.m_expr = string2;
            this.m_len = n;
            this.m_token = n2;
            this.m_ind = n3;
            throw throwable;
        }
    }

    static void IllegalType(Interp interp, int n, int n2) throws TclException {
        throw new TclException(interp, "can't use " + (n == 2 ? "floating-point value" : "non-numeric string") + " as operand of \"" + operatorStrings[n2] + "\"");
    }

    void SyntaxError(Interp interp) throws TclException {
        throw new TclException(interp, "syntax error in expression \"" + this.m_expr + "\"");
    }

    static void DivideByZero(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH DIVZERO {divide by zero}"));
        throw new TclException(interp, "divide by zero");
    }

    static void IntegerTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
        throw new TclException(interp, "integer value too large to represent");
    }

    static void DoubleTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
        throw new TclException(interp, "floating-point value too large to represent");
    }

    static void DomainError(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH DOMAIN {domain error: argument not in valid range}"));
        throw new TclException(interp, "domain error: argument not in valid range");
    }

    private ExprValue ExprParseString(Interp interp, String string) throws TclException {
        int n = string.length();
        if (Expression.ExprLooksLikeInt(string, n, 0)) {
            StrtoulResult strtoulResult;
            int n2 = 0;
            while (Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            if (string.charAt(n2) == '-') {
                strtoulResult = Util.strtoul(string, ++n2, 0);
                strtoulResult.value = -strtoulResult.value;
            } else {
                strtoulResult = string.charAt(n2) == '+' ? Util.strtoul(string, ++n2, 0) : Util.strtoul(string, n2, 0);
            }
            if (strtoulResult.index == n) {
                if (strtoulResult.errno == -2) {
                    interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
                    throw new TclException(interp, "integer value too large to represent");
                }
                this.m_token = 0;
                return new ExprValue(strtoulResult.value);
            }
        } else {
            StrtodResult strtodResult = Util.strtod(string, 0);
            if (strtodResult.index == n) {
                if (strtodResult.errno == -4) {
                    interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
                    throw new TclException(interp, "floating-point value too large to represent");
                }
                this.m_token = 0;
                return new ExprValue(strtodResult.value);
            }
        }
        return new ExprValue(string);
    }

    private ExprValue ExprGetValue(Interp interp, int n) throws TclException {
        ExprValue exprValue;
        int n2;
        boolean bl = false;
        ExprValue exprValue2 = this.ExprLex(interp);
        if (this.m_token == 1) {
            exprValue2 = this.ExprGetValue(interp, -1);
            if (this.m_token != 2) {
                throw new TclException(interp, "unmatched parentheses in expression \"" + this.m_expr + "\"");
            }
        } else {
            if (this.m_token == 12) {
                this.m_token = 28;
            }
            if (this.m_token == 11) {
                this.m_token = 29;
            }
            if (this.m_token >= 28) {
                n2 = this.m_token;
                exprValue2 = this.ExprGetValue(interp, precTable[this.m_token]);
                if (interp.noEval == 0) {
                    switch (n2) {
                        case 28: {
                            if (exprValue2.type == 1) {
                                exprValue2.intValue = -exprValue2.intValue;
                                break;
                            }
                            if (exprValue2.type == 2) {
                                exprValue2.doubleValue = -exprValue2.doubleValue;
                                break;
                            }
                            Expression.IllegalType(interp, exprValue2.type, n2);
                            break;
                        }
                        case 29: {
                            if (exprValue2.type == 1 || exprValue2.type == 2) break;
                            Expression.IllegalType(interp, exprValue2.type, n2);
                            break;
                        }
                        case 30: {
                            if (exprValue2.type == 1) {
                                if (exprValue2.intValue != 0L) {
                                    exprValue2.intValue = 0L;
                                    break;
                                }
                                exprValue2.intValue = 1L;
                                break;
                            }
                            if (exprValue2.type == 2) {
                                exprValue2.intValue = exprValue2.doubleValue == 0.0 ? 1L : 0L;
                                exprValue2.type = 1;
                                break;
                            }
                            Expression.IllegalType(interp, exprValue2.type, n2);
                            break;
                        }
                        case 31: {
                            if (exprValue2.type == 1) {
                                exprValue2.intValue ^= 0xFFFFFFFFFFFFFFFFL;
                                break;
                            }
                            Expression.IllegalType(interp, exprValue2.type, n2);
                        }
                    }
                }
                bl = true;
            } else if (this.m_token != 0) {
                this.SyntaxError(interp);
            }
        }
        if (exprValue2 == null) {
            this.SyntaxError(interp);
        }
        if (!bl) {
            exprValue = this.ExprLex(interp);
        }
        block42: while (true) {
            if ((n2 = this.m_token) < 8 || n2 >= 28) {
                if (n2 == 4 || n2 == 2 || n2 == 3) {
                    return exprValue2;
                }
                this.SyntaxError(interp);
            }
            if (precTable[n2] <= n) {
                return exprValue2;
            }
            if (n2 == 24 || n2 == 25 || n2 == 26) {
                Object var8_11;
                if (exprValue2.type == 2) {
                    exprValue2.intValue = exprValue2.doubleValue != 0.0 ? 1 : 0;
                    exprValue2.type = 1;
                } else if (exprValue2.type == 3) {
                    if (interp.noEval == 0) {
                        Expression.IllegalType(interp, 3, n2);
                    }
                    exprValue2.intValue = 0L;
                }
                if (n2 == 24 && exprValue2.intValue == 0L || n2 == 25 && exprValue2.intValue != 0L) {
                    ++interp.noEval;
                    try {
                        exprValue = this.ExprGetValue(interp, precTable[n2]);
                    }
                    finally {
                        var8_11 = null;
                        --interp.noEval;
                    }
                    if (n2 != 25) continue;
                    exprValue2.intValue = 1L;
                    continue;
                }
                if (n2 == 26) {
                    if (exprValue2.intValue != 0L) {
                        exprValue2 = this.ExprGetValue(interp, precTable[26] - 1);
                        if (this.m_token != 27) {
                            this.SyntaxError(interp);
                        }
                        ++interp.noEval;
                        try {
                            exprValue = this.ExprGetValue(interp, precTable[26] - 1);
                        }
                        finally {
                            var8_11 = null;
                            --interp.noEval;
                        }
                        continue;
                    }
                    ++interp.noEval;
                    try {
                        exprValue = this.ExprGetValue(interp, precTable[26] - 1);
                    }
                    finally {
                        var8_11 = null;
                        --interp.noEval;
                    }
                    if (this.m_token != 27) {
                        this.SyntaxError(interp);
                    }
                    exprValue2 = this.ExprGetValue(interp, precTable[26] - 1);
                    continue;
                }
                exprValue = this.ExprGetValue(interp, precTable[n2]);
            } else {
                exprValue = this.ExprGetValue(interp, precTable[n2]);
            }
            if (this.m_token < 8 && this.m_token != 0 && this.m_token != 4 && this.m_token != 3 && this.m_token != 2) {
                this.SyntaxError(interp);
            }
            if (interp.noEval != 0) continue;
            switch (n2) {
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    if (exprValue2.type == 3 || exprValue.type == 3) {
                        Expression.IllegalType(interp, 3, n2);
                    }
                    if (exprValue2.type == 2) {
                        if (exprValue.type != 1) break;
                        exprValue.doubleValue = exprValue.intValue;
                        exprValue.type = 2;
                        break;
                    }
                    if (exprValue.type != 2 || exprValue2.type != 1) break;
                    exprValue2.doubleValue = exprValue2.intValue;
                    exprValue2.type = 2;
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 21: 
                case 22: 
                case 23: {
                    if (exprValue2.type != 1) {
                        Expression.IllegalType(interp, exprValue2.type, n2);
                        break;
                    }
                    if (exprValue.type == 1) break;
                    Expression.IllegalType(interp, exprValue.type, n2);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    if (exprValue2.type == 3) {
                        if (exprValue.type == 3) break;
                        Expression.ExprMakeString(interp, exprValue);
                        break;
                    }
                    if (exprValue.type == 3) {
                        if (exprValue2.type == 3) break;
                        Expression.ExprMakeString(interp, exprValue2);
                        break;
                    }
                    if (exprValue2.type == 2) {
                        if (exprValue.type != 1) break;
                        exprValue.doubleValue = exprValue.intValue;
                        exprValue.type = 2;
                        break;
                    }
                    if (exprValue.type != 2 || exprValue2.type != 1) break;
                    exprValue2.doubleValue = exprValue2.intValue;
                    exprValue2.type = 2;
                    break;
                }
                case 24: 
                case 25: {
                    if (exprValue2.type == 3) {
                        Expression.IllegalType(interp, exprValue2.type, n2);
                    }
                    if (exprValue.type != 3) break;
                    Expression.IllegalType(interp, exprValue2.type, n2);
                    break;
                }
                default: {
                    throw new TclException(interp, "unknown operator in expression");
                }
                case 26: 
                case 27: 
            }
            switch (n2) {
                default: {
                    continue block42;
                }
                case 8: {
                    if (exprValue2.type == 1) {
                        exprValue2.intValue *= exprValue.intValue;
                        continue block42;
                    }
                    exprValue2.doubleValue *= exprValue.doubleValue;
                    continue block42;
                }
                case 9: 
                case 10: {
                    if (exprValue2.type == 1) {
                        if (exprValue.intValue == 0L) {
                            interp.setErrorCode(TclString.newInstance("ARITH DIVZERO {divide by zero}"));
                            throw new TclException(interp, "divide by zero");
                        }
                        long l = exprValue.intValue;
                        boolean bl2 = false;
                        if (l < 0L) {
                            l = -l;
                            exprValue2.intValue = -exprValue2.intValue;
                            bl2 = true;
                        }
                        long l2 = exprValue2.intValue / l;
                        long l3 = exprValue2.intValue % l;
                        if (l3 < 0L) {
                            l3 += l;
                            --l2;
                        }
                        if (bl2) {
                            l3 = -l3;
                        }
                        exprValue2.intValue = n2 == 9 ? l2 : l3;
                        continue block42;
                    }
                    if (exprValue.doubleValue == 0.0) {
                        interp.setErrorCode(TclString.newInstance("ARITH DIVZERO {divide by zero}"));
                        throw new TclException(interp, "divide by zero");
                    }
                    exprValue2.doubleValue /= exprValue.doubleValue;
                    continue block42;
                }
                case 11: {
                    if (exprValue2.type == 1) {
                        exprValue2.intValue += exprValue.intValue;
                        continue block42;
                    }
                    exprValue2.doubleValue += exprValue.doubleValue;
                    continue block42;
                }
                case 12: {
                    if (exprValue2.type == 1) {
                        exprValue2.intValue -= exprValue.intValue;
                        continue block42;
                    }
                    exprValue2.doubleValue -= exprValue.doubleValue;
                    continue block42;
                }
                case 13: {
                    exprValue2.intValue <<= (int)exprValue.intValue;
                    continue block42;
                }
                case 14: {
                    if (exprValue2.intValue < 0L) {
                        exprValue2.intValue = (exprValue2.intValue ^ 0xFFFFFFFFFFFFFFFFL) >> (int)exprValue.intValue ^ 0xFFFFFFFFFFFFFFFFL;
                        continue block42;
                    }
                    exprValue2.intValue >>= (int)exprValue.intValue;
                    continue block42;
                }
                case 15: {
                    exprValue2.intValue = exprValue2.type == 1 ? (long)(exprValue2.intValue < exprValue.intValue ? 1 : 0) : (exprValue2.type == 2 ? (long)(exprValue2.doubleValue < exprValue.doubleValue ? 1 : 0) : (long)(exprValue2.stringValue.compareTo(exprValue.stringValue) < 0 ? 1 : 0));
                    exprValue2.type = 1;
                    continue block42;
                }
                case 16: {
                    exprValue2.intValue = exprValue2.type == 1 ? (long)(exprValue2.intValue > exprValue.intValue ? 1 : 0) : (exprValue2.type == 2 ? (long)(exprValue2.doubleValue > exprValue.doubleValue ? 1 : 0) : (long)(exprValue2.stringValue.compareTo(exprValue.stringValue) > 0 ? 1 : 0));
                    exprValue2.type = 1;
                    continue block42;
                }
                case 17: {
                    exprValue2.intValue = exprValue2.type == 1 ? (long)(exprValue2.intValue <= exprValue.intValue ? 1 : 0) : (exprValue2.type == 2 ? (long)(exprValue2.doubleValue <= exprValue.doubleValue ? 1 : 0) : (long)(exprValue2.stringValue.compareTo(exprValue.stringValue) <= 0 ? 1 : 0));
                    exprValue2.type = 1;
                    continue block42;
                }
                case 18: {
                    exprValue2.intValue = exprValue2.type == 1 ? (long)(exprValue2.intValue >= exprValue.intValue ? 1 : 0) : (exprValue2.type == 2 ? (long)(exprValue2.doubleValue >= exprValue.doubleValue ? 1 : 0) : (long)(exprValue2.stringValue.compareTo(exprValue.stringValue) >= 0 ? 1 : 0));
                    exprValue2.type = 1;
                    continue block42;
                }
                case 19: {
                    exprValue2.intValue = exprValue2.type == 1 ? (long)(exprValue2.intValue == exprValue.intValue ? 1 : 0) : (exprValue2.type == 2 ? (long)(exprValue2.doubleValue == exprValue.doubleValue ? 1 : 0) : (long)(exprValue2.stringValue.compareTo(exprValue.stringValue) == 0 ? 1 : 0));
                    exprValue2.type = 1;
                    continue block42;
                }
                case 20: {
                    exprValue2.intValue = exprValue2.type == 1 ? (long)(exprValue2.intValue != exprValue.intValue ? 1 : 0) : (exprValue2.type == 2 ? (long)(exprValue2.doubleValue != exprValue.doubleValue ? 1 : 0) : (long)(exprValue2.stringValue.compareTo(exprValue.stringValue) != 0 ? 1 : 0));
                    exprValue2.type = 1;
                    continue block42;
                }
                case 21: {
                    exprValue2.intValue &= exprValue.intValue;
                    continue block42;
                }
                case 22: {
                    exprValue2.intValue ^= exprValue.intValue;
                    continue block42;
                }
                case 23: {
                    exprValue2.intValue |= exprValue.intValue;
                    continue block42;
                }
                case 24: {
                    if (exprValue.type == 2) {
                        exprValue.intValue = exprValue.doubleValue != 0.0 ? 1 : 0;
                        exprValue.type = 1;
                    }
                    exprValue2.intValue = exprValue2.intValue != 0L && exprValue.intValue != 0L ? 1 : 0;
                    continue block42;
                }
                case 25: {
                    if (exprValue.type == 2) {
                        exprValue.intValue = exprValue.doubleValue != 0.0 ? 1 : 0;
                        exprValue.type = 1;
                    }
                    exprValue2.intValue = exprValue2.intValue != 0L || exprValue.intValue != 0L ? 1 : 0;
                    continue block42;
                }
                case 27: 
            }
            break;
        }
        throw new TclException(interp, "can't have : operator without ? first");
    }

    private ExprValue ExprLex(Interp interp) throws TclException {
        Object object;
        while (this.m_ind < this.m_len && Character.isWhitespace(this.m_expr.charAt(this.m_ind))) {
            ++this.m_ind;
        }
        if (this.m_ind >= this.m_len) {
            this.m_token = 4;
            return null;
        }
        char c = this.m_expr.charAt(this.m_ind);
        char c2 = this.m_ind < this.m_len - 1 ? this.m_expr.charAt(this.m_ind + 1) : (char)'\u0000';
        if (c != '+' && c != '-') {
            if (Expression.ExprLooksLikeInt(this.m_expr, this.m_len, this.m_ind)) {
                object = Util.strtoul(this.m_expr, this.m_ind, 0);
                if (((StrtoulResult)object).errno == 0) {
                    this.m_ind = ((StrtoulResult)object).index;
                    this.m_token = 0;
                    return new ExprValue(((StrtoulResult)object).value);
                }
                if (((StrtoulResult)object).errno == -2) {
                    interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
                    throw new TclException(interp, "integer value too large to represent");
                }
            } else {
                object = Util.strtod(this.m_expr, this.m_ind);
                if (((StrtodResult)object).errno == 0) {
                    this.m_ind = ((StrtodResult)object).index;
                    this.m_token = 0;
                    return new ExprValue(((StrtodResult)object).value);
                }
                if (((StrtodResult)object).errno == -4) {
                    interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
                    throw new TclException(interp, "floating-point value too large to represent");
                }
            }
        }
        ++this.m_ind;
        switch (c) {
            case '$': {
                this.m_token = 0;
                object = ParseAdaptor.parseVar(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = ((ParseResult)object).nextIndex;
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                TclObject tclObject = ((ParseResult)object).value;
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                return this.ExprParseString(interp, tclObject.stringRep);
            }
            case '[': {
                this.m_token = 0;
                object = ParseAdaptor.parseNestedCmd(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = ((ParseResult)object).nextIndex;
                TclObject tclObject = ((ParseResult)object).value;
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                String string = tclObject.stringRep;
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                return this.ExprParseString(interp, string);
            }
            case '\"': {
                this.m_token = 0;
                object = ParseAdaptor.parseQuotes(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = ((ParseResult)object).nextIndex;
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                TclObject tclObject = ((ParseResult)object).value;
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                return this.ExprParseString(interp, tclObject.stringRep);
            }
            case '{': {
                this.m_token = 0;
                object = ParseAdaptor.parseBraces(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = ((ParseResult)object).nextIndex;
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                TclObject tclObject = ((ParseResult)object).value;
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                return this.ExprParseString(interp, tclObject.stringRep);
            }
            case '(': {
                this.m_token = 1;
                return null;
            }
            case ')': {
                this.m_token = 2;
                return null;
            }
            case ',': {
                this.m_token = 3;
                return null;
            }
            case '*': {
                this.m_token = 8;
                return null;
            }
            case '/': {
                this.m_token = 9;
                return null;
            }
            case '%': {
                this.m_token = 10;
                return null;
            }
            case '+': {
                this.m_token = 11;
                return null;
            }
            case '-': {
                this.m_token = 12;
                return null;
            }
            case '?': {
                this.m_token = 26;
                return null;
            }
            case ':': {
                this.m_token = 27;
                return null;
            }
            case '<': {
                switch (c2) {
                    case '<': {
                        ++this.m_ind;
                        this.m_token = 13;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 17;
                        break;
                    }
                    default: {
                        this.m_token = 15;
                    }
                }
                return null;
            }
            case '>': {
                switch (c2) {
                    case '>': {
                        ++this.m_ind;
                        this.m_token = 14;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 18;
                        break;
                    }
                    default: {
                        this.m_token = 16;
                    }
                }
                return null;
            }
            case '=': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 19;
                } else {
                    this.m_token = 5;
                }
                return null;
            }
            case '!': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 20;
                } else {
                    this.m_token = 30;
                }
                return null;
            }
            case '&': {
                if (c2 == '&') {
                    ++this.m_ind;
                    this.m_token = 24;
                } else {
                    this.m_token = 21;
                }
                return null;
            }
            case '^': {
                this.m_token = 22;
                return null;
            }
            case '|': {
                if (c2 == '|') {
                    ++this.m_ind;
                    this.m_token = 25;
                } else {
                    this.m_token = 23;
                }
                return null;
            }
            case '~': {
                this.m_token = 31;
                return null;
            }
        }
        if (Character.isLetter(c)) {
            --this.m_ind;
            return this.mathFunction(interp);
        }
        this.m_token = 5;
        return null;
    }

    ExprValue mathFunction(Interp interp) throws TclException {
        MathFunction mathFunction;
        int n = this.m_ind;
        TclObject[] tclObjectArray = null;
        while (this.m_ind < this.m_len) {
            if (!Util.isLetterOrDigit(this.m_expr.charAt(this.m_ind)) && this.m_expr.charAt(this.m_ind) != '_') break;
            ++this.m_ind;
        }
        String string = this.m_expr.substring(n, this.m_ind);
        this.ExprLex(interp);
        if (this.m_token != 1) {
            this.SyntaxError(interp);
        }
        if ((mathFunction = (MathFunction)this.mathFuncTable.get(string)) == null) {
            throw new TclException(interp, "unknown math function \"" + string + "\"");
        }
        int n2 = mathFunction.argTypes.length;
        if (n2 == 0) {
            this.ExprLex(interp);
            if (this.m_token != 2) {
                this.SyntaxError(interp);
            }
        } else {
            tclObjectArray = new TclObject[n2];
            int n3 = 0;
            while (true) {
                ExprValue exprValue = this.ExprGetValue(interp, -1);
                if (exprValue.type == 3) {
                    throw new TclException(interp, "argument to math function didn't have numeric value");
                }
                tclObjectArray[n3] = exprValue.type == 1 ? (mathFunction.argTypes[n3] == 1 ? TclDouble.newInstance((int)exprValue.intValue) : TclInteger.newInstance((int)exprValue.intValue)) : (mathFunction.argTypes[n3] == 0 ? TclInteger.newInstance((int)exprValue.doubleValue) : TclDouble.newInstance(exprValue.doubleValue));
                if (n3 == n2 - 1) {
                    if (this.m_token == 2) break;
                    if (this.m_token == 3) {
                        throw new TclException(interp, "too many arguments for math function");
                    }
                    this.SyntaxError(interp);
                }
                if (this.m_token != 3) {
                    if (this.m_token == 2) {
                        throw new TclException(interp, "too few arguments for math function");
                    }
                    this.SyntaxError(interp);
                }
                ++n3;
            }
        }
        this.m_token = 0;
        if (interp.noEval != 0) {
            return new ExprValue(0L);
        }
        return mathFunction.apply(interp, tclObjectArray);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean ExprLooksLikeInt(String var0, int var1_1, int var2_2) {
        while (var2_2 < var1_1 && Character.isWhitespace(var0.charAt(var2_2))) {
            ++var2_2;
        }
        if (var2_2 >= var1_1) {
            return false;
        }
        var3_3 = var0.charAt(var2_2);
        if (var3_3 == '+' || var3_3 == '-') {
            if (++var2_2 >= var1_1) {
                return false;
            }
            var3_3 = var0.charAt(var2_2);
        }
        if (Character.isDigit(var3_3)) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl14:
            // 2 sources

            ** while (var2_2 < var1_1 && Character.isDigit((char)var0.charAt((int)var2_2)))
        }
lbl15:
        // 1 sources

        return var2_2 >= var1_1 || (var3_3 = var0.charAt(var2_2)) != '.' && var3_3 != 'e' && var3_3 != 'E';
    }

    static void ExprMakeString(Interp interp, ExprValue exprValue) {
        if (exprValue.type == 1) {
            exprValue.stringValue = Long.toString(exprValue.intValue);
        } else if (exprValue.type == 2) {
            exprValue.stringValue = Double.toString(exprValue.doubleValue);
        }
        exprValue.type = 3;
    }

    static void checkIntegerRange(Interp interp, double d) throws TclException {
        if (d < 0.0) {
            if (d < -2.147483648E9) {
                interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
                throw new TclException(interp, "integer value too large to represent");
            }
        } else if (d > 2.147483647E9) {
            interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
            throw new TclException(interp, "integer value too large to represent");
        }
    }

    static void checkDoubleRange(Interp interp, double d) throws TclException {
        if (d == Double.NaN || d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
            throw new TclException(interp, "floating-point value too large to represent");
        }
    }

    static {
        int[] nArray = new int[32];
        nArray[8] = 12;
        nArray[9] = 12;
        nArray[10] = 12;
        nArray[11] = 11;
        nArray[12] = 11;
        nArray[13] = 10;
        nArray[14] = 10;
        nArray[15] = 9;
        nArray[16] = 9;
        nArray[17] = 9;
        nArray[18] = 9;
        nArray[19] = 8;
        nArray[20] = 8;
        nArray[21] = 7;
        nArray[22] = 6;
        nArray[23] = 5;
        nArray[24] = 4;
        nArray[25] = 3;
        nArray[26] = 2;
        nArray[27] = 1;
        nArray[28] = 13;
        nArray[29] = 13;
        nArray[30] = 13;
        nArray[31] = 13;
        precTable = nArray;
        operatorStrings = new String[]{"VALUE", "(", ")", ",", "END", "UNKNOWN", "6", "7", "*", "/", "%", "+", "-", "<<", ">>", "<", ">", "<=", ">=", "==", "!=", "&", "^", "|", "&&", "||", "?", ":", "-", "+", "!", "~"};
    }
}

