/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BinaryMathFunction;
import tcl.lang.ExprValue;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class PowFunction
extends BinaryMathFunction {
    ExprValue apply(Interp interp, TclObject[] tclObjectArray) throws TclException {
        double d = Math.pow(TclDouble.get(interp, tclObjectArray[0]), TclDouble.get(interp, tclObjectArray[1]));
        if (d == Double.NaN || d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
            throw new TclException(interp, "floating-point value too large to represent");
        }
        return new ExprValue(d);
    }

    PowFunction() {
    }
}

