/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.EventDeleter;
import tcl.lang.IdleHandler;
import tcl.lang.TclEvent;
import tcl.lang.TclRuntimeError;
import tcl.lang.TimerEvent;
import tcl.lang.TimerHandler;

public class Notifier {
    private TclEvent firstEvent;
    private TclEvent lastEvent;
    private TclEvent markerEvent;
    Thread primaryThread;
    private static Hashtable notifierTable = new Hashtable();
    Vector timerList;
    int timerGeneration;
    boolean timerPending;
    Vector idleList;
    int idleGeneration;
    int refCount;

    private Notifier(Thread thread) {
        this.primaryThread = thread;
        this.firstEvent = null;
        this.lastEvent = null;
        this.markerEvent = null;
        this.timerList = new Vector();
        this.timerGeneration = 0;
        this.idleList = new Vector();
        this.idleGeneration = 0;
        this.timerPending = false;
        this.refCount = 0;
    }

    public static synchronized Notifier getNotifierForThread(Thread thread) {
        Notifier notifier = (Notifier)notifierTable.get(thread);
        if (notifier == null) {
            notifier = new Notifier(thread);
            notifierTable.put(thread, notifier);
        }
        return notifier;
    }

    public synchronized void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("Attempting to preserve a freed Notifier");
        }
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount == 0 && this.primaryThread != null) {
            throw new TclRuntimeError("Attempting to release a Notifier before it's preserved");
        }
        if (this.refCount <= 0) {
            throw new TclRuntimeError("Attempting to release a freed Notifier");
        }
        --this.refCount;
        if (this.refCount == 0) {
            notifierTable.remove(this.primaryThread);
            this.primaryThread = null;
        }
    }

    public synchronized void queueEvent(TclEvent tclEvent, int n) {
        tclEvent.notifier = this;
        if (n == 0) {
            tclEvent.next = null;
            if (this.firstEvent == null) {
                this.firstEvent = tclEvent;
            } else {
                this.lastEvent.next = tclEvent;
            }
            this.lastEvent = tclEvent;
        } else if (n == 1) {
            tclEvent.next = this.firstEvent;
            if (this.firstEvent == null) {
                this.lastEvent = tclEvent;
            }
            this.firstEvent = tclEvent;
        } else if (n == 2) {
            if (this.markerEvent == null) {
                tclEvent.next = this.firstEvent;
                this.firstEvent = tclEvent;
            } else {
                tclEvent.next = this.markerEvent.next;
                this.markerEvent.next = tclEvent;
            }
            this.markerEvent = tclEvent;
            if (tclEvent.next == null) {
                this.lastEvent = tclEvent;
            }
        } else {
            throw new TclRuntimeError("wrong position \"" + n + "\", must be TCL.QUEUE_HEAD, TCL.QUEUE_TAIL or TCL.QUEUE_MARK");
        }
        if (Thread.currentThread() != this.primaryThread) {
            this.notifyAll();
        }
    }

    public synchronized void deleteEvents(EventDeleter eventDeleter) {
        TclEvent tclEvent = null;
        TclEvent tclEvent2 = this.firstEvent;
        while (tclEvent2 != null) {
            if (eventDeleter.deleteEvent(tclEvent2) == 1) {
                if (this.firstEvent == tclEvent2) {
                    this.firstEvent = tclEvent2.next;
                    if (tclEvent2.next == null) {
                        this.lastEvent = null;
                    }
                } else {
                    tclEvent.next = tclEvent2.next;
                }
                if (this.markerEvent == tclEvent2) {
                    this.markerEvent = null;
                }
            } else {
                tclEvent = tclEvent2;
            }
            tclEvent2 = tclEvent2.next;
        }
    }

    synchronized int serviceEvent(int n) {
        if ((n & 0xFFFFFFFD) == 0) {
            n |= 0xFFFFFFFD;
        }
        TclEvent tclEvent = this.firstEvent;
        while (tclEvent != null) {
            boolean bl = tclEvent.isProcessing;
            tclEvent.isProcessing = true;
            if (!bl && tclEvent.processEvent(n) != 0) {
                tclEvent.isProcessed = true;
                TclEvent tclEvent2 = tclEvent;
                synchronized (tclEvent2) {
                    if (tclEvent.needsNotify) {
                        tclEvent.notifyAll();
                    }
                }
                if (this.firstEvent == tclEvent) {
                    this.firstEvent = tclEvent.next;
                    if (tclEvent.next == null) {
                        this.lastEvent = null;
                    }
                    if (this.markerEvent == tclEvent) {
                        this.markerEvent = null;
                    }
                } else {
                    TclEvent tclEvent3 = this.firstEvent;
                    while (tclEvent3.next != tclEvent) {
                        tclEvent3 = tclEvent3.next;
                    }
                    tclEvent3.next = tclEvent.next;
                    if (tclEvent.next == null) {
                        this.lastEvent = tclEvent3;
                    }
                    if (this.markerEvent == tclEvent) {
                        this.markerEvent = tclEvent3;
                    }
                }
                return 1;
            }
            tclEvent.isProcessing = bl;
            tclEvent = tclEvent.next;
        }
        return 0;
    }

    public synchronized int doOneEvent(int n) {
        int n2 = 0;
        if ((n & 0xFFFFFFFD) == 0) {
            n |= 0xFFFFFFFD;
        }
        while (true) {
            TimerHandler timerHandler;
            if ((n & 0xFFFFFFFD) == 32) {
                return this.serviceIdle();
            }
            long l = System.currentTimeMillis();
            if (!this.timerPending && this.timerList.size() > 0) {
                timerHandler = (TimerHandler)this.timerList.elementAt(0);
                if (timerHandler.atTime <= l) {
                    TimerEvent timerEvent = new TimerEvent();
                    timerEvent.notifier = this;
                    this.queueEvent(timerEvent, 0);
                    this.timerPending = true;
                }
            }
            if (this.serviceEvent(n) != 0) {
                n2 = 1;
                break;
            }
            if ((n & 0x20) != 0 && this.serviceIdle() != 0) {
                n2 = 1;
                break;
            }
            if ((n & 2) != 0) break;
            try {
                if (this.timerList.size() > 0) {
                    timerHandler = (TimerHandler)this.timerList.elementAt(0);
                    long l2 = timerHandler.atTime - l;
                    if (l2 <= 0L) continue;
                    this.wait(l2);
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return n2;
    }

    private int serviceIdle() {
        int n = 0;
        int n2 = this.idleGeneration++;
        while (this.idleList.size() > 0) {
            IdleHandler idleHandler = (IdleHandler)this.idleList.elementAt(0);
            if (idleHandler.generation > n2) break;
            this.idleList.removeElementAt(0);
            if (idleHandler.invoke() == 0) continue;
            n = 1;
        }
        return n;
    }
}

