
// gcc test.cc test_objects.cc tk/libtk.a tcl/libtcl.a -lX11 -lm

#include "test.h"

int
Foo::AfterConfigure(Tcl_Interp* interp)
{
    d = i - f;
    return (TCL_OK);
}

int
Foo::EchoCmd(Tcl_Interp* interp, int ac, char** av)
{
    for (int i = 0; i < ac; i++)
	Tcl_AppendElement(interp, av[i], 0);
    return (TCL_OK);
}

static void
DisplayBar(ClientData cl)
{
    Bar* b = (Bar *) cl;
    b->Draw();
}

int
Bar::AfterConfigure(Tcl_Interp* interp)
{
    Tk_SetBackgroundFromBorder(tkwin, bgBorder);
    
    Tk_GeometryRequest(tkwin, width, height);
    
    // Redraw this widget eventually.
    if (tkwin && Tk_IsMapped(tkwin) && !redraw_pending) {
	Tk_DoWhenIdle(DisplayBar, (ClientData) this);
	redraw_pending = 1;
    }
    
    return (TCL_OK);
}

void
Bar::Draw()
{
    Tk_Fill3DRectangle(Tk_Display(tkwin), Tk_WindowId(tkwin), bgBorder,
		       0, 0, width, height, borderwidth, relief);
    redraw_pending = 0;
}
