#!/bin/sh
#
# This script is run when you're doing a site-wide installation.

if [ $loggingInstall -eq 1 ]; then
    echo "Site wide install:" 1.1 final $nameofuser $nameofhost `date` \
	>> $logFileName
fi
echo Doing a site-wide installation of the Tcl plugin.
echo ""
echo I can install the plugin in /usr/lib/netscape/plugins, or I can
echo install it in another location. If you choose another location,
echo you must provide your users with a wrapper shell script that sets
echo the environment variable NPX_PLUGIN_PATH to where the plugin is
echo installed.
echo ""
echo Please type in the name of the directory where you wish me to
echo install the plugin [/usr/lib/netscape/plugins]:

bindir=/usr/lib/netscape/plugins
read answer
if [ $answer ]; then
    bindir=$answer
    echo ""
fi

if [ -d $bindir ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $bindir exists, reusing >> $logFileName
    fi
    silent=1
else
    if [ -f $bindir ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo $bindir exists but is a file, aborting >> $logFileName
        fi
	echo "	$bindir exists but is a file, aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory $bindir >> $logFileName
        fi
	echo "	Making directory $bindir"
	mkdir $bindir
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
		echo Could not create directory, aborting: $bindir >> $logFileName
            fi
	    echo "	mkdir $bindir failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
echo "	Will install the plugin in $bindir"

echo ""
echo I can install the Tcl script libraries used by the Tcl plugin in one
echo of these locations:
echo ""
echo "	$bindir/../tclplug"
echo "	/usr/lib/netscape/tclplug"
echo ""
echo "or you can choose to install the libraries in another directory."
echo "If you choose to install the Tcl libraries in another directory"
echo "besides those listed above, you will have to provide your users"
echo "with a wrapper shell script that sets the environment variable"
echo "TCL_PLUGIN_DIR to where the Tcl libraries are installed."
echo ""
echo "Please type in the name of the directory where you wish me to"
echo "install the Tcl libraries [$bindir/../tclplug]:"

libdir=$bindir/../tclplug
read answer
if [ $answer ]; then
    libdir=$answer
    echo ""
fi

if [ -d $libdir ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir exists, reusing >> $logFileName
    fi
    silent=1
else
    if [ -f $libdir ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo $libdir exists but is a file, aborting >> $logFileName
        fi
	echo "	$libdir exists but is a file, aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory $libdir >> $logFileName
        fi
	echo "	Making directory $libdir"
	mkdir $libdir
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
		echo Could not create directory, aborting: $libdir >> $logFileName
            fi
	    echo "	mkdir $libdir failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
if [ -d $libdir/html ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir/html exists, reusing >> $logFileName
        echo Making $libdir/html contents writable >> $logFileName
    fi
    chmod 644 $libdir/html/*
    chmod 777 $libdir/html
    /bin/rm -f $libdir/html/.licseen.txt
else
    if [ -f $libdir/html ]; then
        if [ $loggingInstall -eq 1 ]; then
	    echo $libdir/html exists but is a file, aborting installation. >> $logFileName
	fi
	echo "	$libdir/html exists but is a file."
	echo "	Aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory: $libdir/html >> $logFileName
	fi
	echo "	Making directory $libdir/html."
	chmod 777 $libdir/html
	mkdir $libdir/html
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo Could not create directory, aborting: $libdir/html >> $logFileName
	    fi
	    echo "	mkdir $libdir/html failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
if [ -d $libdir/$tclversion ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir/$tclversion exists, reusing >> $logFileName
        echo Making $libdir/$tclversion contents writable >> $logFileName
    fi
    chmod 644 $libdir/$tclversion/*
else
    if [ -f $libdir/$tclversion ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo $libdir/$tclversion exists but is a file, aborting installation. >> $logFileName
	fi
	echo "	$libdir/$tclversion exists but is a file."
	echo "	Aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory: $libdir/$tclversion >> $logFileName
	fi
	echo "	Making directory $libdir/$tclversion."
	mkdir $libdir/$tclversion
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo Could not create directory, aborting: $libdir/$tclversion >> $logFileName
	    fi
	    echo "	mkdir $libdir/$tclversion failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
if [ -d $libdir/$tkversion ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Directory $libdir/$tkversion exists, reusing >> $logFileName
        echo Making $libdir/$tkversion contents writable >> $logFileName
    fi
    chmod 644 $libdir/$tkversion/*
else
    if [ -f $libdir/$tkversion ]; then
	if [ $loggingInstall -eq 1 ]; then
	    echo $libdir/$tkversion exists but is a file, aborting installation. >> $logFileName
	fi
	echo "	$libdir/$tkversion exists but is a file."
	echo "	Aborting installation."
	echo "	Log file is: $logFileName"
	exit 1
    else
	if [ $loggingInstall -eq 1 ]; then
	    echo Making directory: $libdir/$tkversion >> $logFileName
	fi
	echo "	Making directory $libdir/$tkversion."
	mkdir $libdir/$tkversion
	if [ $? -ne 0 ]; then
	    if [ $loggingInstall -eq 1 ]; then
	        echo Could not create directory, aborting: $libdir/$tkversion >> $logFileName
	    fi
	    echo "	mkdir $libdir/$tkversion failed, aborting installation."
	    echo "	Log file is: $logFileName"
	    exit 1
	fi
    fi
fi
echo "	Will install the Tcl libraries in $libdir"
echo ""
echo "Summary:"
echo "	Installing from staging area $staging."
echo "	Will install plugin binaries into $bindir."
echo "	Will install Tcl libraries into $libdir."
echo ""
echo "Please confirm that I should do this? [yes]"
read answer
if [ $answer ]; then
    silent=1
else
    answer=yes
fi
if [ $answer = yes ]; then
    silent=1
else
    if [ $loggingInstall -eq 1 ]; then
	echo Installation aborted by user, goodbye >> $logFileName
    fi
    echo Installation aborted by user, goodbye.
    exit 1
fi
if [ $loggingInstall -eq 1 ]; then
    echo "" >> $logFileName
    echo Preparations completed, will install: >> $logFileName
    echo ------------------------------------- >> $logFileName
    echo "" >> $logFileName
    echo Installing from staging area $staging >> $logFileName
    echo Will install libraries in $libdir >> $logFileName
    echo Will install libtclplugin.so in $objdir >> $logFileName
    echo "" >> $logFileName
fi
echo ""
if [ $onlytesting = 1 ]; then
    echo only testing, goodbye.
    exit 0
fi
echo "Second stage: installing..(This will take between one and five minutes)"
if [ $loggingInstall -eq 1 ]; then
    echo Copying libtclplugin.so to $bindir >> $logFileName
fi
cp -p $staging/libtclplugin.so $bindir
if [ $? -ne 0 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Copy of libtclplugin.so to $bindir failed, aborting >> $logFileName
    fi
    echo "	Installing the plugin object failed, aborting."
    echo "	Log file is: $logFileName"
    exit 1
fi
if [ $loggingInstall -eq 1 ]; then
    echo Copying content of $staging/html to $libdir/html >> $logFileName
fi
cp -p $staging/html/* $libdir/html
if [ $? -ne 0 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Copy of $staging/html failed, aborting >> $logFileName
    fi
    echo "	Installing the html pages failed, aborting."
    echo "	Log file is: $logFileName"
    exit 1
fi
if [ $loggingInstall -eq 1 ]; then
    echo Making content of $libdir/html non-writable >> $logFileName
fi
chmod 444 $libdir/html/*
if [ $loggingInstall -eq 1 ]; then
    echo Copying content of $staging/$tclversion to $libdir/$tclversion >> $logFileName
fi
cp -p $staging/$tclversion/* $libdir/$tclversion
if [ $? -ne 0 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Copy of $staging/$tclversion failed, aborting >> $logFileName
    fi
    echo "	Installing the Tcl Plugin library failed, aborting."
    echo "	Log file is: $logFileName"
    exit 1
fi
if [ $loggingInstall -eq 1 ]; then
    echo Making content of $libdir/$tclversion non-writable >> $logFileName
fi
chmod 444 $libdir/$tclversion/*
if [ $loggingInstall -eq 1 ]; then
    echo Copying content of $staging/$tkversion to $libdir/$tkversion >> $logFileName
fi
cp -p $staging/$tkversion/* $libdir/$tkversion
if [ $? -ne 0 ]; then
    if [ $loggingInstall -eq 1 ]; then
	echo Copy of $staging/$tkversion failed, aborting >> $logFileName
    fi
    echo "	Installing the Tcl Plugin library failed, aborting."
    echo "	Log file is: $logFileName"
    exit 1
fi
if [ $loggingInstall -eq 1 ]; then
    echo Making content of $libdir/$tkversion non-writable >> $logFileName
fi
chmod 444 $libdir/$tkversion/*
if [ $loggingInstall -eq 1 ]; then
    echo Installation from $staging complete, `date` >> $logFileName
fi
echo ""
echo "Installation from $staging completed successfully."
echo ""
echo "Third stage: cleanup."
echo ""
echo "I can now remove all the files in the staging area. If you want to"
echo "install multiple copies of the plugin from this staging area, e.g."
echo "for  different users  or multiple  machines on  your network, tell"
echo "me  to not remove these  files. If you do  not want to do any more "
echo "installations of the  plugin, you  can safely  answer \"yes\"  and I"
echo "will remove these files:"
echo ""
echo "Should I remove all files in the staging area, $staging? [no]"
read answer
if [ $answer ]; then
    silent=1
else
    answer=no
fi
if [ $answer = yes ]; then
    cleanstage=1
else
    cleanstage=0
fi
if [ $cleanstage = 1 ]; then
    echo "	Please confirm that you want to remove all files and"
    echo "	directories in $staging [no]?"
    read answer
    if [ $answer ]; then
	silent=1
    else
	answer=no
    fi
    cleanstage=0
    if [ $answer = yes ]; then
	cleanstage=1
    fi
fi
if [ $cleanstage = 1 ]; then
    echo "Removing files...(This should take a minute)"
    rm -rf $staging
    rmdir $staging
    echo ""
fi
echo ""
echo "Do you wish to test the Tcl Plugin now? [yes]"
read answer
if [ $answer ]; then
   silent=1
else
   answer=yes
fi
if [ $answer = yes ]; then
   export logFileName
   sh .install-test.sh
   exit 0
fi
echo "All done, thanks for installing the Tcl Plugin!"
echo ""
echo "Please exit any copies of Navigator that are running now, and restart"
echo "Navigator 3.0. View the Help->About plug-ins menu item and verify that"
echo "the Tcl plugin is found by Netscape Navigator. If it appears in the"
echo "Installed plug-ins page, you can view the demos at the URL:"
echo "	http://www.sunlabs.com/research/tcl/plugin/index.html"
echo ""
echo "Comments, bug reports, questions --> email to jyl@eng.sun.com"
echo Please include the following log file in bug reports:
echo ""
echo "	$logFileName"
echo ""
exit
