# windows.tcl --
# Windows (3.1/95/NT) platform specific settings

# Pick a display size that fits on a VGA display
option add *Text.height 		30 	startup
option add *Text.width 			80 	startup

# The name of the per-user preferences file
proc Platform_File {key} {
    global WebTk
    switch $key {
	prefs {
	    return [file join $WebTk(userfiles) pref.txt]
	}
	macros {
	    return [file join $WebTk(userfiles) macrousr.tcl]
	}
	tcl {
	    return [file join $WebTk(userfiles) user.tcl]
	}
	def {
	    return [file join $WebTk(userfiles) userpref.txt]
	}
	log {
	    return [file join $WebTk(userfiles) logfile.txt]
	}
	tmp {
	    return [file join $WebTk(userfiles) tmp.txt]
	}
    }
}

# Wait for a dialog before doing a grab
proc Platform_WaitVisibility {win} {
    return
}

proc Platform_TempFile {url} {
    global WebTk
    regsub {(\?|#).*} $url {} url
    catch {file mkdir [file join $WebTk(home) cache]}
    return [file join $WebTk(home) cache [file tail $url]]
}

# Install from the floppy (written on UNIX) to the hard drive
proc Platform_Install {{src a:/} {dest c:/src/WebTk}} {
    set save [pwd]
    cd $src
    foreach f [glob README* license*] {
	puts $f ; update idletasks
	File_Copy $f $dest
    }
    foreach dir {bin lib html images user} \
	    pat {{webtk.tcl} {*.tcl *.app tclIndex} {*.html *.htm} {*.gif *.xbm} {*}} {
	cd [file join $src $dir]
	set dir [file join $dest $dir]
	if ![file isdirectory $dir] {
	    catch {file mkdir $dir}
	}
	if ![file isdirectory $dir] {
	    puts "$dir doesn't exist"
	    continue
	}
	puts $dir ; update idletasks
	foreach f [lsort [eval glob -nocomplain $pat]] {
	    regsub -nocase {.htm$} $f {.html} newf
	    if {[string tolower [file extension $newf]] == ".gif"} {
		puts "$newf (binary)"; update idletasks
		File_CopyBin $f $dir/$newf
	    } else {
		puts $newf ; update idletasks
		File_Copy $f $dir/$newf
	    }
	}
    }
    cd $save
}
# Copy a file
proc File_Copy {src dest} {
    set in [open $src]
    if [file isdirectory $dest] {
	set dest [file join $dest [file tail $src]]
    }
    set out [open $dest w]
    puts $out [read $in]
    close $out
    close $in
}
# Copy a file
catch {rename unsupported0 copychannel}

proc File_CopyBin {src dest} {
    set in [open $src]
    fconfigure $in -trans binary
    if [file isdirectory $dest] {
	set dest [file join $dest [file tail $src]]
    }
    set out [open $dest w]
    fconfigure $out -trans binary
    copychannel $in $out
    close $out
    close $in
}


