set print(prog) [file join $WebTk(bin) html2ps]
proc Print_File {win} {
    global print
    upvar HM$win var
    if {$var(S_dirty)} {
	File_Save $win
    }
    if [regsub ^file: [string trim $var(S_url)] {} file] {
	regsub -all /+ $file / file
    } else {
	set file [Platform_TempFile $var(S_url)]
	Output $win $file
    }
    PrintDialog $win $file
}
proc Print_Selection {win} {
    global print
    if ![catch {InputSelection $win} html] {
	Status $win "Printing selection"
	set file [Platform_TempFile $var(S_url)]
	set out [open $file w]
	puts $out $html
	close $out
	PrintDialog $win $file
    }
}

proc PrintDialog {win file} {
    global print
    upvar #0 Printer$win printer Orient$win orient PStatus$win status
    global env
    catch {destroy $win.print}
    set f [frame $win.print -bd 4 -relief ridge]

    message $f.msg -aspect 2000 -text "Print Settings"
    pack $f.msg -padx 10 -pady 10

    set g [frame $f.printer]
    label $g.label -text Printer
    set printer lp
    catch {set printer $env(PRINTER)}
    entry $g.entry -textvariable Printer$win
    pack $g.label -side left
    pack $g.entry -side top -fill x
    pack $g -padx 10 -pady 10

    set g [frame $f.orient]
    set orient portrait
    radiobutton $g.landscape -text Landscape -variable Orient$win -value landscape
    radiobutton $g.portrait -text Portrait -variable Orient$win -value portrait
    pack $g.landscape $g.portrait -side left
    pack $g -side top -padx 10

    set g [frame $f.but]
    set status 0
    button $g.ok -text OK -command [list set PStatus$win 1]
    button $g.cancel -text Cancel -command [list set PStatus$win 0]
    pack $g.ok -side left
    pack $g.cancel -side right
    pack $g -side top -fill x -padx 10 -pady 10

    place $f -in $win -relx .5 -rely .5 -anchor c

    tkwait variable PStatus$win
    if {$status} {
	Status $win "Printing [file tail $file]"
	if {$orient == "landscape"} {
	    catch {exec $print(prog) -L -s1.25 $file | lpr -P$printer} err
	} else {
	    catch {exec $print(prog) $file | lpr -P$printer} err
	}
	Status $win "Print Complete: $err"
    } else {
	Status $win "Print Canceled"
    }
    destroy $win.print
}

