/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class CaseCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "string ?in? patList body ... ?default body?");
        }
        String string = argv[1].toString();
        TclObject[] caseArgv = argv;
        int body = -1;
        int i = argv[2].toString().equals("in") ? 3 : 2;
        if (argv.length - i == 1) {
            caseArgv = TclList.getElements(interp, argv[i]);
            i = 0;
        }
        block2: while (i < caseArgv.length) {
            if (i == caseArgv.length - 1) {
                throw new TclException(interp, "extra case pattern with no body");
            }
            String caseString = caseArgv[i].toString();
            int len = caseString.length();
            int j = 0;
            while (j < len) {
                char c = caseString.charAt(j);
                if (Character.isWhitespace(c) || c == '\\') break;
                ++j;
            }
            if (j == len) {
                if (caseString.equals("default")) {
                    body = i + 1;
                }
                if (Util.stringMatch(string, caseString)) {
                    body = i + 1;
                    break;
                }
            } else {
                int numPats = TclList.getLength(interp, caseArgv[i]);
                j = 0;
                while (j < numPats) {
                    if (Util.stringMatch(string, TclList.index(interp, caseArgv[i], j).toString())) {
                        body = i + 1;
                        break block2;
                    }
                    ++j;
                }
            }
            i += 2;
        }
        if (body != -1) {
            try {
                interp.eval(caseArgv[body], 0);
            }
            catch (TclException e) {
                if (e.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (\"" + caseArgv[body - 1] + "\" arm line " + interp.errorLine + ")");
                }
                throw e;
            }
        }
    }

    CaseCmd() {
    }
}

