'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_Merge.man,v 1.2 89/03/24 14:16:16 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_Merge tcl
.BS
.SH NAME
Tcl_Merge \- generate a Tcl list from a collection of strings
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
char *
\fBTcl_Merge\fR(\fIargc, argv\fR)
.SH ARGUMENTS
.AP int argc in
Number of strings.
.AP char *argv[] in
Array of strings to combine into list.  Must have \fIargc\fR entries.
.BE

.SH DESCRIPTION
.PP
\fBTcl_Merge\fR is a utility procedure used by several of the Tcl commands.
Given a collection of strings, it generates a result string
that has proper list structure, such that the \fBindex\fR
Tcl command may be used to extract out the original strings.
In order to do this, \fBTcl_Merge\fR may have to add braces
and/or backslashes.  The result string is dynamically allocated
using \fBmalloc()\fR;  the caller must eventually release the space
using \fBfree()\fR.

.SH KEYWORDS
list, strings
