(* Copyright 1991 by Carnegie Mellon University *)

(* Unused: remove unused functions from a list of functions, where only
   the first function is guaranteed to be used.  Define the relation
   used (f,g) to be true iff there is some use (not necessarily a function
   call!) of g in f.

   The set of used functions is the transitive closure of this relation.
   The set of unused functions is the complement of the used functions.*)
   
structure Unused : UNUSED =
  struct
     structure CPS = CPS
     open CPS

     val split = fn pred =>
	 let fun f (nil,a,b) = (rev a,rev b)
               | f (h::t,a,b) = if pred h then f(t,h::a,b) else f(t,a,h::b)
         in fn l => f(l,nil,nil)
         end

    val sieve = fn pred =>
         let fun f nil = nil
               | f (h :: t) = if pred h then h :: f t else f t
         in f
         end

    fun clean nil = nil
      | clean (l as ((top,_,topbody)::t)) =
      let exception Known

          (* body: map function lvars to their bodies *)
              
          val body : lvar -> cexp =
              let val s =  Intmap.new(32, Known) : cexp Intmap.intmap
                  val add = Intmap.add s
              in app (fn (f,_,body) => add(f,body)) l;
                 Intmap.map s
              end

          (* use an intset to mark which functions are visited during the
             dfs *)

          local
            val visited = Intset.new()
          in
            val mark = Intset.add visited
            val isused = Intset.mem visited
          end

          (* add: if a value is an unvisited function, mark it and visit the
             body *)

          fun add (LABEL v) = if isused v then () else (mark v; scan (body v))
            | add _ = ()
          and scan (RECORD (vl,_,c)) = (addrec vl; scan c)
            | scan (SELECT (_,v,_,c)) = (add v; scan c)
            | scan (OFFSET (_,v,_,c)) = (add v; scan c)
            | scan (APP (v,vl)) = (add v; appadd vl)
            | scan (SWITCH (v,cl)) = (add v; appscan cl)
            | scan (PRIMOP(_,vl,_,cl)) = (appadd vl; appscan cl)
            | scan _ = ()
          and appadd nil = ()
            | appadd (h::t) = (add h; appadd t)

          and addrec nil = ()
            | addrec ((h,_)::t) = (add h; addrec t)

	  and appscan nil = ()
            | appscan (h::t) = (scan h; appscan t)

          val _ = (mark top; scan topbody)
          val (ok,bad) = split (fn (f,_,_) => isused f) l
(*        val _ = if exists (not o #2) bad then
	             print "***> Escaping function unused <***\n"
                     else () *)
     in ok
     end
end
