(* Copyright (c) 1991 by Carnegie Mellon University *)

signature CONTROL =
 sig
   structure Bignum : CBIGNUM
    
   (* optimization flags *)

   val unsafeArith: bool ref (* true=disable overflow checking *)
   val arithOpt : bool ref (* true=optimize overflow checking *)
   val regArray : bool ref (* true =place pseudo-registers in global array *)
   val regOpt   : bool ref (* true=place pseudo-registers in auto. variables *)
   val tailOpt  : bool ref (* true=optimize local tail recursion *)
   val integOpt : bool ref (* true =allow function integration *)
   val zeroCheck : bool ref (* true=include heap checks where there is no *)
                               (* allocation *)
   val autoIncrement : bool ref (* true=use autoincrement mode for allocating
				   records *)
   val usageCount : int ref (* how many uses of a variable along a path in an
			       extended basic block before we cache it *)
   val intType : string
   val floatType : string
   val floatSize : int 
   val maxint : Bignum.bignum
   val minint : Bignum.bignum
   val overflow : string
   val mult : string
   val debug : bool ref
   val instrum : bool ref (* add profiling code ? *)
end
