(* Copyright (c) 1991 by Carnegie Mellon University *)

structure CompC = BatchC(
  structure Control = ControlFun(structure Bignum = CBignum)
  structure Call = CallFun(structure CPS = CPS
			   structure Intmap = Intmap
			   structure Bitset = Bitset
			   val debug = Control.debug)
  structure C = CFun(structure Bignum = CBignum
		     structure CPS = CPS)
  structure Machine =
              CMachineFun(structure Control = Control
			  structure C = C)
  structure Print = CPrintFun(structure C = C
			       structure Control = Control
			       structure Machine = Machine)
  structure CodeGen = CPStoC(structure Machine = Machine
			     structure Call = Call
			     structure Control = Control
			     structure FreeMap = CFreeMap
			     structure CPS = CPS)
  structure CodeGen = CPScompC(structure CPSg = CodeGen)
  structure CProcessFile = CProcessFile(structure Print=Print)
  type entrypoint = CodeGen.entrypoint
  fun generate (f,complainer,entrypoint,stream) = 
      Print.printProg (outputc stream,CodeGen.compile(f,complainer,entrypoint))
  val statistics = Machine.statistics)
