(* Overloading information *)

(*
$File: Common/OverloadingInfo.sml $
$Date: 1992/12/18 08:57:50 $
$Revision: 1.2 $
*)

(*$OverloadingInfo: 
	STATOBJECT_PROP PRETTYPRINT OVERLOADING_INFO
*)

functor OverloadingInfo(structure StatObjectProp: STATOBJECT_PROP
			structure PP: PRETTYPRINT
		       ) : OVERLOADING_INFO =
  struct
    type Type = StatObjectProp.Type

    datatype info =
        UNRESOLVED of Type
      | RESOLVED_INT
      | RESOLVED_REAL		

    type StringTree = PP.StringTree
    fun layoutInfo info =
      case info of
        UNRESOLVED tv => PP.LEAF("UNRESOLVED")
      | RESOLVED_INT => PP.LEAF("RESOLVED_INT")
      | RESOLVED_REAL => PP.LEAF("RESOLVED_REAL")
end;
