import java.awt.*;
import java.applet.*;

import java.util.Vector;

public class DrawTest extends Applet {
    public void init() {
	setLayout(new BorderLayout());
	DrawPanel dp = new DrawPanel();
	add("Center", dp);
    }

    public boolean handleEvent(Event e) {
	switch (e.id) {
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  default:
	    return false;
	}
    }

    public static void main(String args[]) {
	Frame f = new Frame("DrawTest");
	DrawTest drawTest = new DrawTest();
	drawTest.init();
	drawTest.start();

	f.add("Center", drawTest);
	f.resize(200, 100);
	f.show();
    }
}

class DrawPanel extends Panel {
    Vector lines = new Vector();
    int x1,y1;
    int x2,y2;
    int xl, yl;

    public DrawPanel() {
	setBackground(Color.gray);
	setForeground(Color.black);
    }

    public boolean handleEvent(Event e) {
	switch (e.id) {
	  case Event.MOUSE_DOWN:
	    lines.addElement(new Rectangle(e.x, e.y, -1, -1));
	    x1 = e.x;
	    y1 = e.y;
	    repaint();
	    return true;
	  case Event.MOUSE_DRAG:
	    lines.addElement(new Rectangle(x1, y1, e.x, e.y));
	    x1 = e.x;
	    y1 = e.y;
	    repaint();
	    return true;
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  default:
	    return false;
	}
    }

    public void paint(Graphics g) {
	int np = lines.size();

	/* draw the current lines */
	g.setPaintMode();
	for (int i=0; i < np; i++) {
	    Rectangle p = (Rectangle)lines.elementAt(i);
	    if (p.width != -1) {
		g.drawLine(p.x, p.y, p.width, p.height);
	    } else {
		g.drawLine(p.x, p.y, p.x, p.y);
	    }
	}
    }
}

	


    
