
% PostScript constants
#define DONE_TAG        1001
#define EVENT_TAG       1002 
#define MKFONT_TAG      1003
#define MKWIN_TAG       1004
#define MAPWIN_TAG      1005
#define UNMAPWIN_TAG    1006
#define MKBITMAP_TAG    1007

cdef ps_initialize(string libname)
    /DoneTag DONE_TAG def
    /EventTag EVENT_TAG def
    /MkWinTag MKWIN_TAG def
    /MkFontTag MKFONT_TAG def
    /MapWinTag MAPWIN_TAG def
    /UnMapWinTag UNMAPWIN_TAG def
    /MkBitmapTag MKBITMAP_TAG def
    libname LoadFile

%---- fonts --------------------------------------------------------------------

cdef ps_makefont(fid, ps, fc, id, cstring cw) => MKFONT_TAG(id, cw)
    fid ps fc mkfont

cdef ps_showtext(fid, mode, pat, x, y, string s)
    s mode pat x y fid showtext
    
cdef ps_mkbitmap(w, h, cstring s, id) => MKBITMAP_TAG(id)
    w h s makebitmap

%---- window management --------------------------------------------------------

cdef ps_makewin(saveunder, id) => MKWIN_TAG(id)
    saveunder makewin

cdef ps_mapwin(int id, int x, int y, int w, int h) => MAPWIN_TAG()
    x y w h id mapwin

cdef ps_unmapwin(int id) => UNMAPWIN_TAG()
    id unmapwin
  
cdef ps_setrect(id, x, y, w, h)
    x y w h id setrect

cdef ps_top(id, top)
    top id Top
    
cdef ps_focus(id)
    id Focus
    
%---- event handling -----------------------------------------------------------

cdef ps_getevent(id, code, flags, at, x, y, w, h)
    => EVENT_TAG(id, code, flags, at, h, w, y, x)

%---- drawing ------------------------------------------------------------------

cdef ps_strokeline(pat, psz, x0, y0, x1, y1)
    pat psz x1 y1 x0 y0 strokeline
    
cdef ps_strokerect(pat, psz, x, y, w, h)
    pat psz x y w h strokerect
    
cdef ps_fillrect(pat, x, y, w, h)
    pat x y w h fillrect

cdef ps_strokeoval(pat, psz, x, y, w, h)
    pat psz x y w h strokeoval
    
cdef ps_filloval(pat, x, y, w, h)
    pat x y w h filloval

cdef ps_strokerrect(pat, psz, rad, x, y, w, h)
    pat psz rad x y w h strokerrect
    
cdef ps_fillrrect(pat, rad, x, y, w, h)
    pat rad x y w h fillrrect
    
cdef ps_openpolygon(x0, y0)
    x0 y0 openpolygon

cdef ps_curveto(x1, y1, x2, y2, x3, y3)
    x1 y1 x2 y2 x3 y3 curveto

cdef ps_strokepolygon(pat, psz)
    pat psz strokepolygon
    
cdef ps_fillpolygon(pat)
    pat fillpolygon

cdef ps_scrollrect(x, y, w, h, dx, dy)
    dx dy x y w h scrollrect

cdef ps_showbitmap(pat, x, y, w, h, id)
    id w h x y pat showbitmap

%---- clipping -----------------------------------------------------------------

cdef ps_setclip(x, y, w, h)
    x y w h setclip
