#ifndef XWindowPort_First
#define XWindowPort_First

#include "../WindowPort.h"
#include "X11.h"

class XWindowPort: public WindowPort {
public:
    XWindow         id;             // current drawable id
    XWindow         winid;          // window id
    XGC             gc;             // window graphic context
    unsigned long   evtMask;        // X event mask
    Point           lastpos;        // "
    Point           fso;            // fullscreen offset
    Point           inputOffset;    // input offset
    GrPattern       lastpat;
    GrMode          lastmode;       
    int             lastpsz;
    Font            *lastfont;
    Rectangle       ovr;
    XPixmap         save;
    Point           savesize;
    XWindowPort     *father;
    bool            mySaveUnder;
    bool            firstdamage;
    
public:
    bool MapEvent(Token *tp, XEvent *xe);
    Point getMousePos(unsigned int&);
    bool HasPushback()
	{ return havepushbacktoken; }

    void setMode(GrMode mode);
    void mapPat(GrPattern pat);
    void setLineWidth(int pSz, GrMode mode);
    
    void MapPat(GrPattern pat)
	{ if (pat != lastpat) mapPat(pat); }
    void SetMode(GrMode mode)
	{ if (mode != lastmode) setMode(mode); }
    void SetLineWidth(int psz, GrMode mode)
	{ if (psz != lastpsz || mode != lastmode) setLineWidth(psz, mode); }
	
public:

    XWindowPort(InpHandlerFun, void*, void*, bool, bool);

    //---- window management
    void DevShow(WindowPort *father, Rectangle);
    void DevHide();
    void DevDestroy2();
    void DevSetRect(Rectangle*);
    void DevTop(bool);

    //---- clipping
    void DevClip(Rectangle, Point);
    void DevResetClip();
    
    //---- graphic
    void DevStrokeLine2(GrPattern, GrMode, int, Rectangle*, GrLineCap, Point, Point);
    void DevStrokeRect2(GrPattern, GrMode, int, Rectangle*);
    void DevFillRect(GrPattern, GrMode, Rectangle*);
    void DevStrokeRRect2(GrPattern, GrMode, int, Rectangle*, Point);
    void DevFillRRect2(GrPattern, GrMode, Rectangle*, Point);
    void DevStrokeOval2(GrPattern, GrMode, int, Rectangle*);
    void DevFillOval2(GrPattern, GrMode, Rectangle*);
    void DevStrokeWedge2(GrPattern, GrMode, int, GrLineCap, Rectangle*, int, int);
    void DevFillWedge2(GrPattern, GrMode, Rectangle*, int, int);
    void DevStrokePolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType, int, GrLineCap);
    void DevFillPolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType);
    void DevShowBitmap(GrPattern, GrMode, Rectangle*, struct Bitmap*);
    bool DevShowChar(FontPtr fdp, Point pos, byte c, bool isnew, Point);
    void DevShowTextBatch(GrPattern, GrMode, Rectangle*, Point);

    //---- scrolling
    void DevScrollRect(Rectangle, Point);
	
    //---- input
    void DevFullscreen(bool);
    void DevGrab(bool);
    void DevGetEvent(Token *t, int timeout, bool);    
    
    //---- cursor
    void DevSetCursor(GrCursor);
    
    //---- mouse
    void DevSetMousePos(Point);
    void DevMoveMousePos(Point);
    
    //---- misc
    void DevBell(long);
    void DevGiveHint(int, int, void*);
};

#endif XWindowPort_First
