//$WindowSystem,TimeoutHandler$
#include "WindowSystem.h"
#include "String.h"
#include "Error.h"
#include "WindowPort.h"
#include "ClipBoard.h"

Rectangle       gScreenRect;
bool            gWinInit;
WindowSystem    *gWindowSystem;

//---- TimeoutHandler ----------------------------------------------------------

extern WindowPort *focusport;
Point lastpos;

class TimeoutHandler : public SysEvtHandler {
public:
    TimeoutHandler() : (0)
	{ }
    void Notify(SysEventCodes, int);
};

void TimeoutHandler::Notify(SysEventCodes, int)
{
    Token t(eEvtIdle, 0, lastpos);
    if (focusport)
	focusport->Send(&t);
}

//---- WindowSystem ------------------------------------------------------------

WindowSystem::WindowSystem(char *name)
{
    wsName= name;
}

WindowSystem::~WindowSystem()
{
    gWinInit= FALSE;
    SafeDelete(gFontManager);
}

bool WindowSystem::Open()
{
    return TRUE;
}

void WindowSystem::Init()
{
    gFontManager= MakeFontManager(LibName);
    
    if (gFontManager == 0)
	Fatal("WindowSystem::Init", "no font manager");
    
    if (gFontManager->Init())
	Fatal("WindowSystem::Init", "initialization of font manager failed");

    gScreenRect= GetScreenRect();
    
    gSystem->AddTimeoutHandler(new TimeoutHandler);
    
    gWinInit= TRUE;
}

Rectangle WindowSystem::GetScreenRect()
{
    return Rectangle(0, 0, 1152, 900);
}

void WindowSystem::MakeWindow(WindowPort**, InpHandlerFun, void*, void*, bool, bool) 
{
}

FontManager *WindowSystem::MakeFontManager(char*)
{
    return 0;
}

void WindowSystem::MakeBitmap(Bitmap **bp, Point sz, short *data)
{
}

void WindowSystem::MakeBitmap(Bitmap **bp, const char *name)
{
}

class ClipBoard *WindowSystem::MakeClipboard()
{
    return new ClipBoard;
}

void WindowSystem::graphicDelay(unsigned int duration)
{
    Wait(duration);
}

bool WindowSystem::interrupted()
{
    return FALSE;
}
