//$VObject,VObjectMover,VObjectStretcher,TextItem,ImageItem,CompositeVObject$
//$VObjectCommand$
#include "VObject.h" 
#include "View.h"
#include "String.h"
#include "OrdCollection.h"
#include "Menu.h"
#include "BlankWin.h"

AbstractMetaImpl(VObject, (I_O(container), I_S(frameId), I_O(inView), I_R(contentRect)));

VObject::VObject(EvtHandler *next, Rectangle r, int id)
{
    Init(id, r, (View*) next);
}

VObject::VObject(Rectangle r, int id)
{
    Init(id, r, 0);
}

VObject::VObject(int id)
{
    Init(id, gRect0, 0);
}

void VObject::Init(int i, Rectangle r, View *v)
{
    container= inView= v;
    frameId= i;
    contentRect= r;
    SetFlag(eVObjDefault+eVObjOpen);
}

void VObject::SetContainer(VObject *v)
{
    container= v;
}

EvtHandler *VObject::GetNextHandler()
{
    return container;
}

View *VObject::GetView()
{
    return inView;
}

class BlankWin *VObject::GetWindow()
{
    if (GetContainer())
	return GetContainer()->GetWindow();
    return (BlankWin*) this;
}

VObject *VObject::GetContainer()
{
    return GetView();
    // return container;
}

void VObject::AddToClipper(class Clipper *clipper)
{
    container= inView= (View*) clipper;
    CalcExtent();
    SetOrigin(gPoint0);
}

void VObject::RemoveFromClipper(class Clipper *clipper)
{
    if (container == clipper)
	container= 0;
}

void VObject::Open(bool mode)
{
    SetFlag(eVObjOpen, mode);
}

Rectangle VObject::GetViewedRect()
{
    return contentRect;
}

Point VObject::GetPortPoint(Point p)
{
    p= ContainerPoint(p);
    if (container)
	return container->GetPortPoint(p);
    return p;
}

void VObject::SetFocus(Rectangle r, Point o)
{
    if (GetContainer() && r.Clip(contentRect))
	GetContainer()->SetFocus(r, o);
}

VObject *VObject::Detect(BoolFun find, void *arg)
{
    if (find(this, this, arg))
	return this;
    return 0;
}

static bool Comp1(Object*, Object *op, void *v)
{
    return (((VObject*)(op))->GetId() == (int)v);
}

static bool Comp2(Object*, Object *op, void *v)
{
    return ((VObject*)(op))->ContainsPoint(*((Point*)v));
}

static bool Comp3(Object*, Object *op, void *v)
{
    return op->IsEqual((VObject*)v);
}

VObject *VObject::FindItem(int id)
{
    return Detect(Comp1, (void*) id);
}

VObject *VObject::FindItem(Point p)
{
    return Detect(Comp2, &p);
}

VObject *VObject::FindItem(VObject *g)
{
    return Detect(Comp3, g);
}

void VObject::SetView(View *vp)
{
    inView= vp;
}

Metric VObject::GetMinSize()
{
    return Metric(contentRect.extent);
}

void VObject::CalcExtent()
{
    SetExtent(GetMinSize().Extent());
}

int VObject::Base()
{ 
    return contentRect.extent.y;
}

void VObject::SetOrigin(Point origin)
{
    if (contentRect.origin != origin) {
	contentRect.origin= origin;
	if (TestFlag(eVObjLayoutCntl))
	    Control(GetId(), cPartOriginChanged, this);
    }
}

void VObject::SetExtent(Point extent)
{
    if (contentRect.extent != extent) {
	contentRect.extent= extent;
	if (TestFlag(eVObjLayoutCntl))
	    Control(GetId(), cPartExtentChanged, this);
    }
}

void VObject::SetContentRect(Rectangle r, bool redraw)
{
    if (!redraw && contentRect == r)
	return;
    if (redraw) {
	InvalidateRect(contentRect);
	InvalidateRect(r);
    }
    if (contentRect.extent != r.extent)
	SetExtent(r.extent);
    SetOrigin(r.origin);
    if (redraw)
	Changed();
}

void VObject::Align(Point at, Metric m, VObjAlign ga)
{
    switch (ga & eVObjH) {
    case eVObjHLeft:
	break;
    case eVObjHCenter:
	at.x+= (m.Width() - Width())/2;
	break;
    case eVObjHRight:
	at.x+= m.Width() - Width();
	break;
    }
    switch (ga & eVObjV) {
    case eVObjVBase:
	at.y+= m.Base() - Base();
	break;
    case eVObjVCenter:
	at.y+= (m.Height() - Height())/2;
	break;
    case eVObjVBottom:
	at.y+= m.Height() - Height();
	break;
    }
    SetOrigin(at);
}

bool VObject::ContainsPoint(Point p)
{
    return contentRect.ContainsPoint(p);
}    

void VObject::Print()
{
    extern int ShowPrintDialog(VObject*);
    
    ShowPrintDialog(this);
}

void VObject::DrawAll(Rectangle r)
{
    if (IsOpen() && r.Clip(contentRect)) {
	if (this->Overridden(VObject, DrawBackground))
	    DrawBackground(r);
	Draw(r);
	if (this->Overridden(VObject, DrawForeground))
	    DrawForeground(r);
    }
}

void VObject::Draw(Rectangle r)
{
}

void VObject::DrawBackground(Rectangle r)
{
}

void VObject::DrawForeground(Rectangle r)
{
}

void VObject::Highlight(HighlightState)
{
    GrInvertRect(contentRect);
}

void VObject::Outline2(Point p1, Point p2)
{
    GrStrokeRect(NormRect(p1, p2));
}

void VObject::Outline(Point delta)
{
    OutlineRect(contentRect+delta);
}

void VObject::OutlineRect(Rectangle r)
{
    Outline2(r.NW(), r.SE());
}

static Rectangle xoldrect;
bool gInFeedback;

void VObject::Feedback(Rectangle r, bool on, bool b)
{
    View *vp= GetView();

    if (vp && b) {  // double buffer mode
	if (on) {
	    Rectangle rr= Union(xoldrect, r);

	    if (gBatch)
		GrGiveHint(eHintBatch, sizeof(Rectangle), &rr);
	    else
		Focus(rr);

	    GrSetPenMode(eRopCopy);
	    GrSetMode(eRopCopy);

	    gInFeedback= TRUE;
	    SetContentRect(r, FALSE);
	    gInFeedback= FALSE;
	    GrEraseRect(rr);
	    vp->DrawAll(rr);

	    GrGiveHint(eHintTextUnbatch);
	    if (gBatch)
		GrGiveHint(eHintUnbatch);
	}
    } else
	OutlineRect(r);
}

void VObject::InvalidateRect(Rectangle r)
{
    if (IsOpen() && GetContainer() && r.IsNotEmpty())
	GetContainer()->InvalidateRect(r);
}

void VObject::ForceRedraw()
{ 
    InvalidateRect(contentRect); 
}

void VObject::UpdateEvent(bool batch)
{
    if (IsOpen() && GetContainer())
	GetContainer()->UpdateEvent(batch);
}

GrCursor VObject::GetCursor(Point)
{
    return eCrsBoldArrow;
}

void VObject::Move(Point delta, bool redraw)
{
    if (delta == gPoint0)
	return;
    if (redraw)
	ForceRedraw();
    SetOrigin(GetOrigin()+delta);
    if (redraw) {
	ForceRedraw();
	Changed();
    }
}

char *VObject::AsString()
{
    return "~";
}

int VObject::Compare(ObjPtr op)
{
    return strcmp(AsString(), op->AsString());
}

void VObject::Enable(bool b, bool redraw)
{
    SetFlag(eVObjEnabled, b);
    if (redraw)
	ForceRedraw();
}

ostream& VObject::PrintOn(ostream &s)
{
    EvtHandler::PrintOn(s);
    return s << frameId SP << contentRect SP;
}

istream& VObject::ReadFrom(istream &s)
{
    EvtHandler::ReadFrom(s);
    return s >> frameId >> contentRect;
}

Command *VObject::Input(Point lp, Token t, Clipper *vf)
{
    if (ContainsPoint(lp) /* && IsOpen() */) {
	if (Enabled())
	    return DispatchEvents(lp, t, vf);
	return gNoChanges;
    }
    return 0;     
}

Command *VObject::DispatchEvents(Point lp, Token t, Clipper *vf)
{
    if (t.Code == eEvtLeftButton && !(t.Flags & eFlgButDown) &&
	    (t.Flags & eFlgShiftKey) && (t.Flags & eFlgCntlKey) &&
		    (t.Flags & eFlgMetaKey)) {
	Inspect();
	return gNoChanges;
    }
    if (t.IsMouseButton() || t.Code == eEvtEnter || t.Code == eEvtExit 
		    || t.Code == eEvtLocMove || t.Code == eEvtLocStill)
	GrSetCursor(GetCursor(lp));

    return EvtHandler::DispatchEvents(lp, t, vf);
}

Command *VObject::DoRightButtonDownCommand(Point lp, Token, int, Clipper *vf)
{
    Menu *menu;

    if (vf && (menu= GetMenu())) {
	int cmdno;

	if (menu->IsNew())
	    DoCreateMenu(menu);                     // append menu items
	menu->DisableAll();
	DoSetupMenu(menu);                          // enable some menu items
	if ((cmdno= menu->Show(lp, vf)) >= 0) {     // show menu in window
	    vf->Focus();
	    return DoMenuCommand(cmdno);
	}
    }
    return gNoChanges;
}

void VObject::StartInputFocus(bool)
{
}

Command *VObject::GetMover()
{
    if (GetView())
	return new VObjectMover(this, GetView()->contentRect);
    return new VObjectMover(this);
}

Command *VObject::GetStretcher()
{
    if (GetView())
	return new VObjectStretcher(this, GetView()->contentRect);
    return new VObjectStretcher(this);
}

//---- VObjectCommand ----------------------------------------------------------

VObjectCommand::VObjectCommand(VObject *g) : (555)
{
    vop= g;
}

void VObjectCommand::Init(VObject *g, Rectangle cr, Point gr, GrCursor cd, int hy)
{
    vop= g;
    constrainRect= cr;
    grid= gr;
    newcursor= cd;
    firstmove= FALSE;
    hysterese= hy;
    oldRect= newRect= vop->ContentRect();  
}

Command *VObjectCommand::TrackMouse(TrackPhase atp, Point ap, Point, Point np)
{
    switch (atp) {
    case eTrackPress:
	oldcursor= GrGetCursor();
	break;

    case eTrackRelease:
	GrSetCursor(oldcursor);

	if(vop->GetView() && !TestFlag(eCmdFullScreen))     
	    vop->SetContentRect(oldRect, FALSE);

	if (TestFlag(eCmdCanUndo))
	    break;
	DoIt();
	return gNoChanges;

    case eTrackMove:
	delta= np - ap;
	if (abs(delta.x) > hysterese || abs(delta.y) > hysterese) {
	    firstmove= TRUE;
	    GrSetCursor(newcursor);
	}
	xoldrect= vop->contentRect;
	break;
    }
    return this;
}

void VObjectCommand::TrackConstrain(Point ap, Point, Point *np)
{
    Rectangle r= oldRect;

    r.origin+= *np-ap;
    *np+= r.AmountToTranslateWithin(constrainRect);
    if (grid >= 1)
	*np= (*np/grid) * grid;     // align to grid
}

void VObjectCommand::TrackFeedback(Point, Point, bool on)
{
    if (firstmove)
	vop->Feedback(newRect, on, !TestFlag(eCmdFullScreen));
}

void VObjectCommand::DoIt()
{
    vop->SetContentRect(newRect, TRUE);
}

void VObjectCommand::UndoIt()
{
    vop->SetContentRect(oldRect, TRUE);
}

//---- VObjectMover ------------------------------------------------------------

VObjectMover::VObjectMover(VObject *g) : (g)
{
    Init(g, gRect0, gPoint1, eCrsMoveHand, 2);
}

VObjectMover::VObjectMover(VObject *g, Rectangle cr) : (g)
{
    Init(g, cr, gPoint1, eCrsMoveHand, 2);
}

VObjectMover::VObjectMover(VObject *g, Rectangle cr, Point gr, GrCursor cd, int hy)
							: (g)
{
    Init(g, cr, gr, cd, hy);
}

void VObjectMover::Init(VObject *g, Rectangle cr, Point gr, GrCursor cd, int hy)
{
    SetName("move");
    VObjectCommand::Init(g, cr, gr, cd, hy);
}

Command *VObjectMover::TrackMouse(TrackPhase atp, Point ap, Point pp, Point np)
{
    Command *cmd= VObjectCommand::TrackMouse(atp, ap, pp, np);
    switch (atp) {
    case eTrackMove:
	newRect= oldRect;
	newRect.origin+= delta;
	return this;
    case eTrackRelease:
	if (newRect == oldRect)
	    cmd= gNoChanges;
	break;
    }
    return cmd;
}

//---- VObjectStretcher --------------------------------------------------------

VObjectStretcher::VObjectStretcher(VObject *g) : (g)
{
    Init(g, gRect0, Point(1), eCrsMoveStretch, 2, g->GetMinSize());
}

VObjectStretcher::VObjectStretcher(VObject *g, Rectangle cr) : (g)
{
    Init(g, cr, Point(1), eCrsMoveStretch, 2, g->GetMinSize());
}

VObjectStretcher::VObjectStretcher(VObject *g, Rectangle cr, Point ms) : (g)
{
    Init(g, cr, ms, eCrsMoveStretch, 2, g->GetMinSize());
}

VObjectStretcher::VObjectStretcher(VObject *g, Rectangle cr, Point ms, Point gr,
				    GrCursor cd, int hy) : (g)
{
    Init(g, cr,  gr, cd, hy, ms);
}

void VObjectStretcher::Init(VObject *g, Rectangle cr, Point gr,
						GrCursor cd, int hy, Point ms)
{
    SetName("resize");
    VObjectCommand::Init(g, cr, gr, cd, hy);
    minSize= ms;
}

void VObjectStretcher::TrackConstrain(Point ap, Point, Point *np)
{  
    switch (corner) {
    case 0: case 4:
	np->x= ap.x;
	break;
    case 2: case 6:
	np->y= ap.y;
	break;
    }
}

Command *VObjectStretcher::TrackMouse(TrackPhase atp, Point ap, Point pp, Point np)
{
    Point p1, p2;

    switch (atp) {
    case eTrackPress:
	VObjectCommand::TrackMouse(atp, ap, pp, np);
	corner= oldRect.PointToCorner(ap);
	break;

    case eTrackMove:
	VObjectCommand::TrackMouse(atp, ap, pp, np);
	p1= oldRect.NW();
	p2= oldRect.SE();

	switch (corner) {
	case 0: case 6: case 7:
	    p1+= delta;
	    break;
	case 1:
	    p2.x+= delta.x;
	    p1.y+= delta.y;
	    break;
	case 5:
	    p1.x+= delta.x;
	    p2.y+= delta.y;
	    break;
	default: // case 2: case 3: case 4:
	    p2+= delta;
	    break;
	}
	newRect= NormRect(p1, p2);
	newRect.extent= Max(newRect.extent, minSize);
	break;

    case eTrackRelease:
	return VObjectCommand::TrackMouse(atp, ap, pp, np);
    }
    return this;
}

//---- TextItem ----------------------------------------------------------------

Point gBorder(4, 3);

MetaImpl(TextItem, (I_CS(text), I_FT(font), I_P(border)));

TextItem::TextItem(char *t, FontPtr f, Point b)
{
    font= f;
    border= b;
    text= 0;
    strreplace(&text, t);
    SetFlag(eVObjHFixed);
}

TextItem::TextItem(int id, char *t, FontPtr f, Point b) : (id)
{
    font= f;
    border= b;
    text= 0;
    strreplace(&text, t);
    SetFlag(eVObjHFixed);
}

TextItem::~TextItem()
{
    SafeDelete(text);
}

void TextItem::SetString(char *t, bool redraw)
{
    if (t) {
	if (redraw) {
	    InvalidateRect(contentRect);
	    strreplace(&text, t);
	    CalcExtent();
	    InvalidateRect(contentRect);
	} else
	    strreplace(&text, t);
	Changed();
    }
}

void TextItem::SetFString(bool redraw, char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    if (redraw) {
	InvalidateRect(contentRect);
	strfreplace(&text, fmt, ap);
	CalcExtent();
	InvalidateRect(contentRect);      
    } else
	strfreplace(&text, fmt, ap);
    Changed();
    va_end(ap);
}

Metric TextItem::GetMinSize()
{
    return Metric(font->Width(text), font->Spacing(), font->Ascender()).Expand(border);
}

int TextItem::Base()
{
    return font->Ascender() + border.y;
}

char *TextItem::AsString()
{
    return text;
}

void TextItem::Draw(Rectangle)
{
    if (text && *text) {
	Point p= contentRect.origin+border;
	p.y+= font->Ascender();
	GrShowString(font, Enabled() ? ePatBlack : ePatGrey50, eRopCopy, p, text);
    }
}

ostream& TextItem::PrintOn (ostream &s)
{
    VObject::PrintOn(s);
    s << font SP << border SP;
    return PrintString(s, text);
}

istream& TextItem::ReadFrom(istream &s)
{
    SafeDelete(text);
    VObject::ReadFrom(s);
    s >> font >> border;
    return ReadString(s, &text);
}

void TextItem::InspectorId(char *buf, int bufSize)
{
    strn0cpy(buf, text, bufSize);
}

//---- ImageItem ---------------------------------------------------------------

MetaImpl0(ImageItem);

ImageItem::ImageItem(Bitmap *b)
{
    deleteBitmap= FALSE;
    bmp= b;
}

ImageItem::ImageItem(int id, Bitmap *b) : (id)
{
    deleteBitmap= FALSE;
    bmp= b;
}

ImageItem::ImageItem(short *s, Point e)
{
    deleteBitmap= TRUE;
    bmp= new Bitmap(e, s);
}

ImageItem::~ImageItem()
{
    if (deleteBitmap)
	SafeDelete(bmp);
}

Metric ImageItem::GetMinSize()
{
    return Metric(bmp->Size());
}

void ImageItem::Draw(Rectangle)
{
    GrPaintBitMap(contentRect, bmp, Enabled() ? ePatBlack : ePatGrey50);
}

ostream& ImageItem::PrintOn (ostream &s)
{
    VObject::PrintOn(s);
    return s << bmp SP;
}

istream& ImageItem::ReadFrom(istream &s)
{
    SafeDelete(bmp);
    VObject::ReadFrom(s);
    return s >> bmp;
}

//---- CompositeVObject --------------------------------------------------------------

AbstractMetaImpl(CompositeVObject, (I_B(modified), I_O(list)));

CompositeVObject::CompositeVObject(int id, Collection *cp) : (id)
{
    list= cp;
    if (list == 0)
	list= new OrdCollection;
    modified= TRUE;
}

CompositeVObject::CompositeVObject(int id, VObject*, ...) : (id)
{
    va_list ap;
    va_start(ap, id);
    list= new OrdCollection;
    SetItems(ap);
    modified= TRUE;
    va_end(ap);
}

CompositeVObject::CompositeVObject(int id, va_list ap) : (id)
{
    list= new OrdCollection;
    SetItems(ap);
    modified= TRUE;
}

CompositeVObject::~CompositeVObject()
{
    SafeDelete(list);
}

void CompositeVObject::FreeAll()
{
    if (list) {
	list->FreeAll();
	SafeDelete(list);
    }    
}

Collection *CompositeVObject::GetList()
{
    return list;
}

int CompositeVObject::Size()
{
    if (list)
	return list->Size();
    return 0;
}

void CompositeVObject::Add(VObject *vop)
{
    if (vop) {
	if (list == 0)
	    list= new OrdCollection;
	list->Add(vop);
	vop->SetContainer(this);
    }
}

Iterator *CompositeVObject::GetIterator()
{
    if (list)
	return list->GetIterator();
    return 0;
}

void CompositeVObject::Open(bool mode)
{
    VObject::Open(mode);
    if (list) {
	list->ForEach(CompositeVObject,Open)(mode);
    }
}

void CompositeVObject::DoUpdate(Object *op, void*)
{
    if (op == list)
	modified= TRUE;
}

VObject *CompositeVObject::Detect(BoolFun find, void *arg)
{
    VObject *g1, *g2;
    Iter next(list);

    while (g1= (VObject*) next())
	if (g2= g1->Detect(find, arg))
	    return g2;
    if (VObject::Detect(find, arg))
	return (VObject*) this;
    return 0;
}

void CompositeVObject::DownControl(int id, int part, void *val)
{
    list->ForEach(VObject,DownControl)(id, part, val);
}

void CompositeVObject::SetItems(va_list ap)
{
    list->AddVector(ap);
    list->ForEach(VObject,SetContainer)(this);
}

void CompositeVObject::SetView(View *vp)
{
    VObject::SetView(vp);
    list->ForEach(VObject,SetView)(vp);
}

void CompositeVObject::SetContainer(VObject *v)
{
    VObject::SetContainer(v);
    list->ForEach(VObject,SetContainer)(this);
}

void CompositeVObject::Enable(bool b, bool redraw)
{
    VObject::Enable(b);
    list->ForEach(VObject,Enable)(b, redraw);
}

void CompositeVObject::Draw(Rectangle r)
{
    list->ForEach(VObject,DrawAll)(r);
}

void CompositeVObject::Outline2(Point p1, Point p2)
{
    list->ForEach(VObject,Outline2)(p1, p2);
}

Command *CompositeVObject::DispatchEvents(Point lp, Token t, Clipper *vf)
{
    Command *cmd;
    RevIter next((SeqCollection*)list);
    VObject *dip;

    while (dip= (VObject*) next()) 
	if (cmd= dip->Input(lp, t, vf))
	    return cmd;
    return VObject::DispatchEvents(lp, t, vf);
}

void CompositeVObject::SetOrigin(Point at)
{
    VObject::SetOrigin(at);
    list->ForEach(VObject,SetOrigin)(at);
}

void CompositeVObject::SetExtent(Point e)
{
    VObject::SetExtent(e);
    list->ForEach(VObject,CalcExtent)();
}

Metric CompositeVObject::GetMinSize()
{
    Metric m;
    Iter next(list);
    VObject *dip;

    while (dip= (VObject*) next())
	m.Merge(dip->GetMinSize());
    return m;
}

ostream& CompositeVObject::PrintOn(ostream &s)
{
    VObject::PrintOn(s);
    return s << list SP;
}

istream& CompositeVObject::ReadFrom(istream &s)
{
    VObject::ReadFrom(s);
    s >> list;
    modified= TRUE;
    return s;
}

void CompositeVObject::InspectorId(char *buf, int sz)
{
    if (list && list->Size() && list->At(0))
	list->At(0)->InspectorId(buf, sz);
    else
	VObject::InspectorId(buf, sz);
}

