//$SortedObjList$
#include "SortedObjList.h"

MetaImpl(SortedObjList, I_B(ascending));

ObjPtr SortedObjList::Add(ObjPtr op)
{
    register ObjLink *l;
    register int comp;
    
    CheckActiveIter("Sort");

    if (first == 0) {
	Insert(op);
	return 0;
    }
    
    for (l = first; l; l= l->Next()) {
	comp = op->Compare(l->Op());        
	if ((ascending && comp < 0) || (!ascending && comp > 0)) {
	    if (l == first)
		Insert(op);
	    else {
		new ObjLink(op, l);
		size++;
		Changed();
	    }                
	    return 0;
	}
    }
    
    if (l == 0)
	ObjList::Add(op); 
    return 0;
}

void SortedObjList::AddFirst(ObjPtr)
{
    MayNotUse("AddFirst");
}

void SortedObjList::AddLast(ObjPtr)
{
    MayNotUse("AddLast");
}

void SortedObjList::InsertBefore(ObjPtr, ObjPtr)
{
    MayNotUse("InsertBefore");
}

void SortedObjList::InsertAfter(ObjPtr, ObjPtr)
{
    MayNotUse("InsertAfter");
}

