#ifndef Slider_First
#define Slider_First

#include "VObject.h"

typedef enum {
    eSliderPageUpLeft   = 1,
    eSliderPageDownRight= 2,
    eSliderThumb        = 3
} SliderPartCodes;

class Slider: public CompositeVObject {
    Point maxVal, currVal, lastVal, bubbleSize;
    class Thumb *thumb;

public:
    MetaDef(Slider);
    Slider(int id= cIdNone, bool vertical= TRUE);

    void Update();
    void SetOrigin(Point);
    void SetExtent(Point);
    Command *DoLeftButtonDownCommand(Point, Token, int);
    void DrawBackground(Rectangle);
    void SetVal(Point);
    void SetMax(Point);
    void SetBubbleSize(Point);
    GrCursor GetCursor(Point);
    void MoveThumb(Point);
    int Where(Point);
    Metric GetMinSize();
};

class PagerCommand: public Command {
    Slider *slider;
    int part;
public:
    PagerCommand(Slider* s, int p);
    void TrackFeedback(Point, Point, bool);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
};

#endif Slider_First

