//$Slider,PagerCommand,Thumb,ThumbMover$
#include "Slider.h"
#include "View.h"

//---- ThumbMover ------------------------------------------------------------

class ThumbMover: public Command {
    Rectangle thumbRect;
    Slider *slider;
public:
    ThumbMover(Rectangle, Slider*);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackFeedback(Point, Point, bool)
	{ /* indirect feedback */ }
    void TrackConstrain(Point, Point, Point*);
};

ThumbMover::ThumbMover(Rectangle tr, Slider *sl) : (555)
{
    slider= sl;
    thumbRect= tr;
}

void ThumbMover::TrackConstrain(Point ap, Point, Point *np)
{
    Rectangle r= thumbRect.Inset(2);
    
    r.origin+= *np-ap;
    *np+= r.AmountToTranslateWithin(slider->contentRect);
}

Command *ThumbMover::TrackMouse(TrackPhase atp, Point ap, Point, Point np)
{
    if (atp == eTrackMove)
	slider->MoveThumb(thumbRect.origin + (np - ap));
    else if (atp == eTrackRelease)
	return gNoChanges;
    return this;
}

//---- Thumb -------------------------------------------------------------------

class Thumb: public VObject {
    Slider *slider;
    GrCursor cursor;
public:
    MetaDef(Thumb);
    Thumb(Slider *sl, GrCursor c) : (Rectangle(20), eSliderThumb)
	{ slider= sl; cursor= c; }
    void Draw(Rectangle r)
	{ GrPaintRect(r, ePatGrey50); GrStrokeRect(contentRect); }
    Metric GetMinSize()
	{ return Metric(20); }
    Command *DoLeftButtonDownCommand(Point, Token, int)
	{ return new ThumbMover(contentRect, slider); }
    GrCursor GetCursor(Point)
	{ return cursor; }
};

MetaImpl0(Thumb);

//---- Slider ------------------------------------------------------------------

MetaImpl(Slider, (I_P(maxVal), I_P(currVal), I_P(lastVal), I_P(bubbleSize)));

Slider::Slider(int id, bool v)
	   : (id, new Thumb(this, v ? eCrsUpDownArrow : eCrsLeftRightArrow), 0)
{
    currVal= lastVal= gPoint0;
    maxVal= 100;
    thumb= (Thumb*) At(0);
    bubbleSize= thumb->GetMinSize().extent;
}

void Slider::SetVal(Point v)
{
    currVal= v;
    //Update();
}

void Slider::SetMax(Point v)
{
    maxVal= v;
    //Update();
}

void Slider::SetBubbleSize(Point s)
{
    bubbleSize= s;
    //Update();
}

void Slider::SetExtent(Point e)
{
    VObject::SetExtent(e);
    //Update();
}

void Slider::SetOrigin(Point at)
{
    VObject::SetOrigin(at);
    Update();
}

Metric Slider::GetMinSize()
{
    return thumb->GetMinSize();
}

void Slider::Update()
{
    Point mv, framesize= GetExtent();
    Rectangle b;
    
    b.origin= GetOrigin();
    if (maxVal.x)
	b.extent.x= int(float(bubbleSize.x*framesize.x) / float(maxVal.x));
    if (maxVal.y)
	b.extent.y= int(float(bubbleSize.y*framesize.y) / float(maxVal.y));
    b.extent= Min(b.extent, framesize);
    b.extent= Max(b.extent, thumb->GetMinSize().extent);
    framesize-= b.extent;
    mv= maxVal-bubbleSize;
    if (mv.x)
	b.origin.x+= int(float(currVal.x*framesize.x) / float(mv.x));
    if (mv.y)
	b.origin.y+= int(float(currVal.y*framesize.y) / float(mv.y));
    if (thumb->contentRect != b)
	thumb->SetContentRect(b, TRUE);
}

void Slider::MoveThumb(Point pos)
{
    Point val, framesize;
    
    framesize= GetExtent() - thumb->GetExtent();
    pos-= GetOrigin();
    if (framesize.x)
	val.x= int(float(pos.x* (maxVal.x-bubbleSize.x)) / float(framesize.x));
    if (framesize.y)
	val.y= int(float(pos.y* (maxVal.y-bubbleSize.y)) / float(framesize.y));
    Control(GetId(), eSliderThumb, &val);
}

void Slider::DrawBackground(Rectangle r)
{
    GrPaintRect(r, ePatGrey12);
    GrStrokeRect(contentRect);
}

int Slider::Where(Point lp)
{
    if (lp.x >= thumb->contentRect.NW().x && lp.x <= thumb->contentRect.NE().x) {
	if (lp.y < thumb->contentRect.origin.y)
	    return 1;
	return 2;
    }
    if (lp.y >= thumb->contentRect.NW().y && lp.y <= thumb->contentRect.SW().y) {
	if (lp.x < thumb->contentRect.origin.x)
	    return 3;
	return 4;
    }
    return 0;
}

Command *Slider::DoLeftButtonDownCommand(Point lp, Token, int)
{
    switch (Where(lp)) {
    case 1:
    case 3:
	return new PagerCommand(this, eSliderPageUpLeft);
    case 2:
    case 4:
	return new PagerCommand(this, eSliderPageDownRight);
    }
    return gNoChanges;
}

GrCursor Slider::GetCursor(Point lp)
{
    switch (Where(lp)) {
    case 1:
	return eCrsUpArrow;
    case 2:
	return eCrsDownArrow;
    case 3:
	return eCrsLeftArrow;
    case 4:
	return eCrsRightArrow;
    }
    return VObject::GetCursor(lp);
}

//---- PagerCommand ------------------------------------------------------------

PagerCommand::PagerCommand(Slider* s, int p) : (0, 0, eCmdDefault | eCmdIdleEvents)
{
    slider= s;
    part= p;
}

void PagerCommand::TrackFeedback(Point, Point, bool)
{
}

Command *PagerCommand::TrackMouse(TrackPhase atp, Point, Point, Point np)
{
    switch (atp) {
    case eTrackPress:
    case eTrackIdle:
	if (slider->ContainsPoint(np))
	    slider->Control(slider->GetId(), part, (void*)0);
	break;
    case eTrackRelease:
	return gNoChanges;
    }
    return this;
}
