//$Set,SetIter,SetDeletedObj$

#include "Set.h"
#include "Error.h"
#include <math.h>

//---- place holder for deleted objects in a set ------------------------------

class SetDeletedObj: public DeletedObject {
    int hash;
public:
    SetDeletedObj(int h)
	{ hash= h; }
    int Hash () // do not break collision chain
	{ return hash; }
};

//---- set ------------------------------------------------------------

const cSetExpandFactor = 2;
const cSetShrinkFactor = 2;

MetaImpl(Set, (I_I(initSize), I_O(cont)));

Set::Set(int s)
{
    size= initSize= SetNextPrime(max(s, cCollectionInitCap));
    cont= new ObjArray(initSize);
}

Set::~Set()
{
    SafeDelete(cont);
}

void Set::InitNew()
{
    size= SetNextPrime(cCollectionInitCap);
    cont= new ObjArray(initSize);
}

ObjPtr Set::Add(ObjPtr op)
{
    int slot;
    Object *ret= 0;

    if (op == 0)
	return 0;
    if (InIterator())
	Error("Add", "while iterator is active");
    if (cont == 0)
	cont= new ObjArray(initSize);
    slot = FindElement (op);

    if (cont->At(slot) == 0) {
	size++;
	cont->AtPut(slot,op);
    }
    else
	ret= op;
    if (HighWaterMark())
	Expand(cSetExpandFactor * cont->Size());
    return ret;
}

void Set::Filter(ObjPtr op)
{
    int slot;

    if (op == 0)
	return;
    if (InIterator())
	Error("Filter", "while iterator is active");
    slot = FindElement (op);

    if (cont->At (slot) == 0) {
	size++;
	cont->AtPut (slot,op);
    } else 
	delete op;

    if (HighWaterMark())
	Expand(cSetExpandFactor * cont->Size()); 
}

ObjPtr Set::Remove(ObjPtr op)
{
    ObjPtr removedOp;
    int i;

    if (op == 0)
	return 0;
    i = FindElement(op);

    if ((removedOp= cont->At (i)) == 0) 
	return 0;

    if (InIterator()) {
	cont->AtPut (i, new SetDeletedObj(cont->At(i)->Hash()));
	AnnounceRemove();
	return removedOp;
    }
    else {
	cont->AtPut(i, 0);
	FixCollisions(i);
	size--;
	if (LowWaterMark())
	    Expand (cont->Size() / cSetShrinkFactor); 
    }
    return removedOp;
}

ObjPtr Set::RemovePtr(ObjPtr op)
{
    return Remove(op);
}

ObjPtr Set::At(int)
{
    MayNotUse ("At");
    return 0;
}

void Set::Empty (int s)                                         
{
    if (InIterator())
	Error("Empty", "while iterator is active");
    if (cont) {
	delete cont;
	s= max(s, cCollectionInitCap);
	cont = new ObjArray(s); 
	size = 0;
	Changed();
    }
}

bool Set::Contains (ObjPtr op)                                         
{
    if (op == 0)
	return FALSE;
    if (cont->At (FindElement(op)) != 0)
	return TRUE;
    return FALSE;
}

bool Set::ContainsPtr (ObjPtr op)                                         
{
    return Contains(op);
}

//---- find the slot of op or return the index of the next empty slot
//     the starting point of the search op hash is invoked. In case
//     of a collision the next empty slot (linerar hashing) will be tried

int Set::FindElement (ObjPtr op)                                         
{
    register slot,n;
    ObjPtr slotOp;
    int size;

    if (cont == 0)
	cont= new ObjArray(initSize);
    size = cont->Size();
    slot = op->Hash() % size;
    for (n = 0; n < size; n++) {
	if ((slotOp = cont->At(slot)) == 0)
	    return slot;
	if (op->IsEqual (slotOp))
	    return slot;
	if (++slot == size)
	    slot = 0;
    } 
    Error("FindElement", "set is full");
    return 0;
}

//---- fix the hole in the collision chain

void Set::FixCollisions (int index)                                         
{
    int oldIndex, nextIndex;
    Object *nextObject;
    
    oldIndex= index+1;
    for (;;oldIndex++) {
	if (oldIndex >= size)
	    oldIndex= 0;
	nextObject= cont->At(oldIndex);
	if (nextObject == 0)
	    break;
	nextIndex= FindElement(nextObject);
	if (nextIndex != oldIndex) {
	    cont->AtPut(nextIndex, nextObject);
	    cont->AtPut(oldIndex, 0);
	}
    }
}

void Set::RemoveDeleted()
{
    Object *op;

    for (int j= 0; j < cont->Size();) {
	op= cont->At(j);
	if (op && op->IsDeleted()) {
	    SafeDelete(op);
	    cont->AtPut(j, 0);
	    FixCollisions(j);
	    size--;
	}    
	else
	    j++;
    }
}

ObjPtr Set::Find(ObjPtr op)
{ 
    if (op == 0 || cont == 0)
	return 0;
    return cont->At (FindElement(op));
}

ObjPtr Set::FindPtr(ObjPtr op)
{ 
    return Find(op);
}

Iterator *Set::GetIterator() 
{ 
    return new SetIter(this); 
}

SetPtr Set::Union (SetPtr sp)
{
    SetPtr aUnion = new Set;

    aUnion->AddAll(this);
    aUnion->AddAll(sp);
    return aUnion;
}

SetPtr Set::Difference (SetPtr sp)
{
    SetPtr diff = new Set;

    diff->AddAll (this);
    diff->RemoveAll (sp);
    return diff;
}    

SetPtr Set::Intersection (SetPtr sp)
{
    SetIter next(this);
    register SetPtr intSec = new Set;
    register ObjPtr op;

    while (op = next())
	if (sp->Contains(op))
	    intSec->Add(op);
    return intSec;
}

void Set::Expand(int newSize)
{
    // ensure that the newSize is a prime number
    newSize= SetNextPrime(newSize);
    ObjArray *oldCont = cont;
    cont = new ObjArray(newSize);
    size = 0;
    AddAll(oldCont);    
    delete oldCont;    
}

//---- class SetIter ----------------------------------------------------------

SetIter::SetIter(Collection *s)
{ 
    cs= (Set *)s; 
    ce= 0; 
}

Collection *SetIter::Coll()
{
    return cs;
}

void SetIter::Reset(Collection *s)
{
    if (s == 0)
	s= Coll();
    cs= (Set*) s;
    ce= 0;
    IteratorEnd();
    Iterator::Reset(s);
}

SetIter::~SetIter()
{
    IteratorEnd();
}

ObjPtr SetIter::operator()()
{
    if (cs->cont == 0)
	return 0;
    IteratorStart();
    int sz= cs->cont->Size();
    // find next non empty item
    for (;ce < sz; ce++) {
	  Object *op= cs->cont->UncheckedAt(ce);
	  if (op != 0 && !op->IsDeleted())
	    break;
    }    
    if (ce < sz) 
	return cs->cont->UncheckedAt(ce++);
    IteratorEnd();
    return 0;
}

bool SetIter::Filter(ObjPtr)
{
    return TRUE;
}

//-----------------------------------------------------------------------------

int SetNextPrime(int x)
{
    int n, sqr;
    if (x <= 3) 
	return 3;
	
    if (x % 2 == 0) 
	x++;
    sqr = (int) sqrt(x) + 1;
    for (;;) {
	for (n = 3; (n <= sqr) && (x % n != 0); n+= 2) 
	    ;
	if (n > sqr) 
	    return x;
	x+= 2;
    }
}
