//$SunFont,SunFontManager$
#include "SunFont.h"
#include "../String.h"

extern void sunfont_free(SunFont*);
extern Font *ConvertFont(SunFont*, GrFace, Font*, bool);

//---- SunFontManager ----------------------------------------------------------

SunFont::SunFont(char *vname, GrFont fid, int ps, GrFace fc)
{
    family= (byte) fid;
    size= (byte) ps;
    face= (byte) fc;
    if (vname)
	vfontname= strsave(vname);
    else
	vfontname= 0;
}

SunFont::~SunFont()
{
    sunfont_free(this);
    notdef= pixfont= 0;
    SafeDelete(vfontname);
}

bool SunFont::Loaded()
{
    return loaded;
}

Font *SunFont::MakeFont(Font**, GrFace fc)
{
    return ConvertFont(this, fc, new SunFont(0, family, size, face | fc), family == eFontCourier);
}

//---- SunFontManager ----------------------------------------------------------

Font* SunFontManager::MakeFont(char *vname, GrFont fid, int ps, GrFace fc)
{
    return new SunFont(vname, fid, ps, fc);
}

Font *SunFontManager::ScaleFont(Font *ofp, GrFont fid, int ps, GrFace face)
{
    SunFont *sfp= new SunFont(0, fid, ps, face);
    sfp->ScaleFont(ofp);
    return sfp;
}
