//$SunClipBoard,ClipboardConnection$
#include "SunClipboard.h"

#include "../Error.h"
#include "../String.h"
#include "../membuf.h"
#include "SunWindowSystem.h"
#include "../Clipboard.h"

#include "../SUNOS/sunsockets.h"

#include <osfcn.h>

class ClipboardConnection : public SysEvtHandler {
public:
    int sock, sequence;
    FILE *ifp, *ofp;
    bool empty;
    SunClipBoard *clip;

public:
    ClipboardConnection(SunClipBoard*, bool*);
    ~ClipboardConnection();
    
    void Notify(SysEventCodes, int);
    void Flush()
	{ fflush(ofp); }
    void Send(struct Message &m);
};

//---- SunClipBoard ------------------------------------------------------------

SunClipBoard::SunClipBoard()
{
    bool ok;
    conn= new ClipboardConnection(this, &ok);
    if (ok)
	gSystem->AddFileInputHandler(conn);
    else
	SafeDelete(conn);
}

SunClipBoard::~SunClipBoard()
{
    SafeDelete(conn);
}

void SunClipBoard::ScratchChanged()
{
    struct Message m;
    
    if (conn) {
	m.tag= eMsgHaveClipboard;
	conn->Send(m);
    }
}

membuf *SunClipBoard::MakeBuf()
{
    struct Message m;
    membuf *mb= 0;
    
    if (conn) {
	m.tag= eMsgGetClipboard;
	conn->Send(m);
	fread((char*)&m, sizeof(struct Message), 1, conn->ifp);
	if (m.len >= 0) {
	    mb= new membuf(m.len);
	    fread(mb->Buf(), m.len, 1, conn->ifp);
	    mb->Setsize(m.len);
	    mb->Reset();
	}
    }
    return mb;
}

//---- ClipboardConnection -----------------------------------------------------

ClipboardConnection::ClipboardConnection(SunClipBoard *sc, bool *ok) : (0)
{
    clip= sc;
    *ok= FALSE;
    sequence= 0;
    sock= ConnectService(SERVERNAME, SERVICENAME);
    if (sock >= 0) {
	ifp= fdopen(sock, "r");
	ofp= fdopen(sock, "w");
	*ok= TRUE;
    }
    empty= TRUE;
    SetResourceId(sock);
}

ClipboardConnection::~ClipboardConnection()
{
    if (ofp) {
	fflush(ofp);
	fclose(ofp);
    }
    if (ifp)
	fclose(ifp);
    close(sock);
}

void ClipboardConnection::Send(Message &m)
{
    if (fwrite((char*)&m, sizeof(struct Message), 1, ofp) == 0) {
	cerr << "ClipboardConnection::Send: write error\n";
	Remove();
	return;
    }
    fflush(ofp);
}

void ClipboardConnection::Notify(SysEventCodes, int)
{
    struct Message m;
    struct Response rp;
    char *buf;
    
    if (read(sock, (char*)&rp, sizeof(struct Response)) != sizeof(struct Response)) {
	SysError("ClipboardConnection::Notify", "read");
	Remove();
	return;
    }
    switch (rp.tag) {
    
    case eMsgGetClipboard:
	buf= clip->GetBuf(&m.len);
	if (buf && m.len > 0) {
	    m.tag= eMsgGetClipboard;
	    Send(m);
	    if (fwrite(buf, m.len, 1, ofp) == 0) {
		Remove();
		Error("ClipboardConnection::Dispatch",
					    "eMsgSendClipboard: write error");
	    }
	    fflush(ofp);
	}
	break;
	
    case eMsgNotOwner:
	clip->NotOwner();
	break;
	
    default:
	Warning("ClipboardConnection::Dispatch", "wrong request");
	Remove();
	break;
    }
}
