//$SunBitmap$
#include "SunBitmap.h"

#include "sunbitmap.h"

SunBitmap::SunBitmap(Point sz, short *im)
{
    size= sz;
    image= im;
    pr= sunbitmap_create(size, image);
    spr= 0;
}

SunBitmap::SunBitmap(const char *name)
{
    if (pr= sunbitmap_load((char*) name)) {
	size= sunbitmap_size(pr);
	image= sunbitmap_image(pr);
    } else
	cerr << "can't load bitmap\n";
    spr= 0;
}

SunBitmap::~SunBitmap()
{
    if (pr)
	sunbitmap_free(pr);
    if (spr)
	sunbitmap_free(spr);
    pr= spr= 0;
}
