//$PullDownBar,PullDownItem,PullDownMenu$
#include "PullDownFrame.h"
#include "OrdCollection.h"

//---- PullDownBar -------------------------------------------------------------

MetaImpl0(PullDownBar);

PullDownBar::PullDownBar(EvtHandler *h, class Collection *l) :
			    (0, l, eCVClearSelection+eCVDontStuckToBorder, 1, 0)
{
    handler= h;
    SetGap(Point(6, 0));
}

void PullDownBar::DoOnItem(int m, VObject *vp, Point)
{
    cmdno= -1;
    if (vp && vp->IsKindOf(PullDownItem) && m == 1)
	cmdno= ((PullDownItem*)vp)->ShowMenu();
}

void PullDownBar::DoSelect(Rectangle r)
{
    CollectionView::DoSelect(r);
    if (cmdno >= 0 && handler)
	handler->PerformCommand(handler->DoMenuCommand(cmdno));
}

//---- PullDownItem ------------------------------------------------------------

MetaImpl(PullDownItem, I_O(menu));

PullDownItem::PullDownItem(PullDownMenu *m) : (cIdNone, m ? m->GetTitle() : 0, 0)
{
    menu= m;
}

PullDownItem::~PullDownItem()
{
    SafeDelete(menu);
}

int PullDownItem::ShowMenu()
{
    int cmdno= -1;
    if (menu) {
	menu->SetExitRect(Rectangle(0, -contentRect.extent.y,
				  contentRect.extent.x, contentRect.extent.y));
	menu->SetSelectedItem(gPoint_1);
	VObject::Highlight(On);
	cmdno= menu->Show(contentRect.SW()+gPoint2, this);
	VObject::Highlight(Off);
    }
    return cmdno;
}

void PullDownItem::Highlight(HighlightState)
{
}

//---- PullDownMenu ------------------------------------------------------------

MetaImpl(PullDownMenu, I_R(exitRect));

PullDownMenu::PullDownMenu(char *title, bool s= FALSE, int r= 0, int c= 1)
						    : (title, s, r, c, FALSE)
{
}

PullDownMenu::PullDownMenu(VObject *title, bool s= FALSE, int r= 0, int c= 1)
						: (title, s, r, c, FALSE)
{
}

void PullDownMenu::DoOnItem(int m, VObject *vop, Point p)
{
    if (p.y < -2 && !exitRect.ContainsPoint(p))
	Close();
    else
	Menu::DoOnItem(m, vop, p);
}

Point PullDownMenu::InitialPos()
{
    clipper->Scroll(cPartScrollAbs, gPoint0, FALSE);
    return gPoint0;
}
