//$Point$
#include "Point.h"
#include "Class.h"
#include <math.h>

const Point gPoint_1(-1), gPoint0, gPoint1(1), gPoint2(2), gPoint3(3),
			gPoint4(4), gPoint8(8), gPoint10(10), gPoint16(16);

static Class PointClassMetaImpl0("Point",
				  sizeof (Point),
				  0,
				  __FILE__,
				  "./Point.h",
				  __LINE__,
				  1,
				  __COMPILEDIR__,
				  __COMPILEDIR__);

Point Min(Point p1, Point p2)
{
    return Point(min(p1.x, p2.x), min(p1.y, p2.y));
}

Point Max(Point p1, Point p2)
{ 
    return Point(max(p1.x, p2.x), max(p1.y, p2.y));
}

Point Abs(Point p)
{
    return Point(abs(p.x), abs(p.y));
}

Point Sign(Point p)
{
    return Point(sign(p.x), sign(p.y));
}

float Phi(Point p)
{
    float r;
    
    r= atan2((float)p.y,(float)p.x) * 180.0 / PI;
    if (r < 0.0)
	r+= 360.0;
    return r * PI / 180.0;
}

float Length(Point p)      /* return sqrt(p.x*p.x + p.y*p.y); */
{
    register double x, y, r, s;
    int t;
    
    if (p.x < 0.0)
	p.x= -p.x;
    if (p.y < 0.0)
	p.y= -p.y;
    if (p.x < p.y) {
	t= p.x;
	p.x= p.y;
	p.y= t;
    }
    if (p.x == 0)
	return p.y;
    x= double(p.x);
    y= double(p.y);
    for (;;) {
	r= y/x;
	r*= r;
	s= r + 4;
	if (s == 4)
	    return x;
	r/= s;
	x+= (r + r) * x;
	y*= r;
    }
}

ostream& operator<< (ostream& s, Point p)
{
    s.put('(');
    s << p.x;
    s.put(',');
    s << p.y;
    s.put(')');
    return s;
}

istream& operator>> (istream& s, Point& p)
{
    int x, y;
    char c= 0;
    
    s >> c;
    if (c == '(') {
	s >> x >> c;
	if (c == ',') {
	    s >> y >> c;
	    if (c != ')')
		s.clear(_bad);
	} else
	    s.clear(_bad);
    } else
	s.clear(_bad);
    if (s)
	p= Point(x,y);
    return s;
}

char *Point::AsString()
{
    return form("x: %d y: %d", x, y);
}

