//$VObjTreeView$

#include "VObjTreeView.h"
#include "TreeView.h"
#include "Inspector.h"
#include "ObjectTable.h"
#include "Alert.h"
#include "OrdCollection.h"
#include "DialogItems.h"

const int cObjItemId= 1001;

//---- VObjTreeView ----------------------------------------------------------

MetaImpl0(VObjTreeView);

VObjTreeView::VObjTreeView() : ((EvtHandler*)0)
{
}

Command *VObjTreeView::NodeSelected(VObject *t, int)
{
    VObject *vop= t->FindItem(cObjItemId);
    if (vop) {
	Object *op= Guard(vop, ObjectItem)->GetObject();
	if (ObjectTablePtrIsValid(op))
	    op->Inspect();
	else
	    NoteAlert.Show("instance 0x%x disappeard", op);
    }
    return gNoChanges;
}

void VObjTreeView::ShowVObjTree(VObject *vop)
{
    SetTree((TreeNode*)BuildVObjTree(FindRoot(vop)));
}

VObject *VObjTreeView::BuildVObjTree(VObject *vop)
{
    VObject *g= MakeLeaf(vop);
    OrdCollection *list= new OrdCollection;
    list->Add(g);
    if (vop->IsKindOf(CompositeVObject)) {
	CompositeVObject *cop= (CompositeVObject*)vop;
	Iter next(cop->GetIterator());
	    while (vop= (VObject*)next()) {
		VObject *newitem= BuildVObjTree(vop);
		if (!newitem->IsKindOf(TreeNode))
		    newitem= new TreeNode(cIdNone, newitem, 0);
		list->Add(newitem);
	    }
    }
    return new TreeNode(cIdNone, list);
}

VObject *VObjTreeView::FindRoot(VObject *vop)
{
    Object *ep;
    while (ep= vop->GetNextHandler()) {
	if (!ep->IsKindOf(CompositeVObject))
	    break;
	vop= (VObject*)ep;
    }
    return vop;
}

VObject *VObjTreeView::MakeLeaf(Object *vop)
{
    char buf[20], *cp;
    buf[0]= '\0';
    vop->InspectorId(buf, sizeof buf);
    if (strlen(buf))
	cp= buf;
    else
	cp= form("0x%x", (int) vop);
    return
	new Cluster(cIdNone, eVObjHCenter, 0,
	    new TextItem(vop->ClassName(), new Font(gFixedFont->Fid(), 
			    gFixedFont->Size(), eFaceBold), Point(2,1)),
	    new ObjectItem(cObjItemId, cp, vop),
	    0
	);
}

