//$CollTableView$

#include "CollTableView.h"
#include "Inspector.h"
#include "ObjectTable.h"
#include "OrdCollection.h"
#include "Collection.h"
#include "Alert.h"

//---- VObjTreeView ----------------------------------------------------------

CollTableView::CollTableView() : (0, 0, 0)
{
}

void CollTableView::ShowCollection(Collection* col)
{
    if (col->Size() == 0)
	return;
    Iter next(col);
    char buf[200], *cp;
    OrdCollection *oc= new OrdCollection;
    Object *op; 
    
    while (op= next()) {
	op->InspectorId(buf, sizeof buf);
	cp= form("0x%x (%s): %s", (int) op, op->ClassName(), buf);
	oc->Add(new ObjectItem(cIdNone, cp, op));
    }    
    SetCollection(oc);
    Update();
    UpdateEvent();
}

void CollTableView::DoSelect(Rectangle r)
{
    Object *op, *sel= GetCollection()->At(r.origin.y);
    op= Guard(sel, ObjectItem)->GetObject();
    if (ObjectTablePtrIsValid(op))
	op->Inspect();
    else
	NoteAlert.Show("instance 0x%x disappeard", op);
}
