//$ClassItem$

#include "ClassItem.h"
#include "Class.h"
#include "String.h"

//---- ClassItem -----------------------------------------------------

MetaImpl(ClassItem, (I_O(cl)));

ClassItem::ClassItem(int id, Class *c, char *label) : (id, c->Name(),
      new Font(gFixedFont->Fid(), gFixedFont->Size(),
		     c->IsAbstract() ? eFaceItalic :eFacePlain
		     ), Point(2,1))
{
    cl= c;
    if (label)
	SetString(label);
}

int ClassItem::Compare(ObjPtr op)
{
    return strcmp(ClassName(), Guard(op, ClassItem)->ClassName());
}

bool ClassItem::IsEqual(ObjPtr b)
{
    return b->IsKindOf(ClassItem) &&
	    strcmp(ClassName(), ((ClassItem*)b)->ClassName()) == 0;
}
