//$ObjLink,ObjList,ObjListIter,RevObjListIter,ObjLink$
#include "ObjList.h"
#include "FixedSizeStorage.h"
#include "System.h"
#include "Storage.h"

//---- ObjLink -----------------------------------------------------------------

MetaImpl(ObjLink, (I_O(next), I_O(previous), I_O(op)));

FIXED_OBJ_STORAGE(ObjLink, 100);

ObjLink::ObjLink(ObjPtr a, ObjLink* n, ObjLink* p)
{ 
    FIXED_SIZE_ALLOC(ObjLink);
    op= a; 
    next= n; 
    previous= p; 
}

ObjLink::ObjLink(ObjPtr a, ObjLink *l)
{
    FIXED_SIZE_ALLOC(ObjLink);
    op= a;
    next= l;
    previous= l->previous;
    l->previous->next= this;
    l->previous= this;
}

ObjLink::~ObjLink()
{
    FIXED_SIZE_DEALLOC(ObjLink);
}

void ObjLink::FreeAll()
{
    if (op) {
	op->FreeAll();
	SafeDelete(op);
    }
}

//---- ObjList -----------------------------------------------------------------

MetaImpl(ObjList, (I_O(first), I_O(last)));

ObjList::ObjList()
{
    first= last= 0;
}

ObjList::~ObjList()
{
    register ObjLink *l, *ll;

    for(l= first; l; l= ll) {
	ll= l->next;
	SafeDelete(l);
    }
    first= last= 0;
}

void ObjList::FreeAll()
{
    register ObjLink *l, *ll;

    for (l= first; l; l= ll) {
	ll= l->next;
	l->FreeAll();
	SafeDelete(l);
    }
    first= last= 0;
    size= 0;
}

void ObjList::RemoveDeleted()
{
    register ObjLink *l, *p;

    l= first;
    while (l) {
	p= l;
	l= l->next;
	if (p->op->IsDeleted()) {
	    SafeDelete(p->op);
	    RemoveLink(p);
	}
    }
}

void ObjList::Insert(ObjPtr a)
{
    CheckActiveIter("Insert");
    first= new ObjLink(a, first, 0);
    if (last == 0)
	last= first;
    else 
	first->next->previous= first;
    size++;
    Changed();
}

void ObjList::InsertBefore(ObjPtr before, ObjPtr op)
{
    register ObjLink *l;

    CheckActiveIter("InsertBefore");
    for (l = first; l ; l= l->next) {
	if (l->op->IsEqual(before)) {
	    if (l == first)
		Insert(op);
	    else {
		new ObjLink(op, l);
		size++;
		Changed();
	    }                
	    return;
	}
    }    
    if (l == 0)
	Error("InsertBefore", "object not found");
}

void ObjList::InsertAfter(ObjPtr after, ObjPtr op)
{
    register ObjLink *l;

    CheckActiveIter("InsertAfter");
    for (l = first; l ; l= l->next) {
	if (l->op->IsEqual(after)) {
	    l= l->next;
	    if (l == 0)
		Add(op); 
	    else {
		new ObjLink(op, l);
		size++;
		Changed();
	    }                
	    return;
	}
    }    
    if (l == 0)
	Error ("InsertAfter", "object not found");
}

ObjPtr ObjList::Add(ObjPtr a)
{
    CheckActiveIter("Add");
    last= new ObjLink(a, 0, last);
    if (first == 0)
	first= last;
    else
	last->previous->next= last;
    size++;
    Changed();
    return 0;
}

ObjPtr ObjList::Replace(ObjPtr a, ObjPtr b)
{
    register ObjLink *l;
    ObjPtr t;

    for(l= first; l; l= l->next) {
	if (l->op == a) {
	    t= l->op;
	    l->op= b;
	    Changed();
	    return t;
	}
    }
    return 0;
}

ObjPtr ObjList::First()
{
    return GetAt(0);
}

ObjPtr ObjList::Last()
{
    register ObjLink *l;

    for(l= last; l; l= l->previous) 
	if (!l->op->IsDeleted()) 
	    return l->op;
    return 0;
}

ObjPtr ObjList::Remove(ObjPtr a)
{   
    register ObjLink *l;
    register ObjPtr op= 0;

    for(l= first; l; l= l->next) {
	if (l->op->IsEqual(a)) {
	    op= l->op;
	    RemoveLink(l);
	    break;
	}
    }
    return op;
}

ObjPtr ObjList::RemovePtr(ObjPtr a)
{   
    register ObjLink *l;
    register ObjPtr op= 0;

    for(l= first; l; l= l->next) {
	if (l->op == a) {
	    op= l->op;
	    RemoveLink(l);
	    break;
	}
    }
    return op;
}

void ObjList::RemoveLink(ObjLink *l)
{
    if (InIterator()) {
	l->op= new DeletedObject;
	AnnounceRemove();
    }
    else {
	if (l->next)
	    l->next->previous= l->previous;
	else
	    last= l->previous;
	if (l->previous)
	    l->previous->next= l->next;
	else
	    first= l->next;
	delete l;
	size--;
    }
    Changed();
}

ObjPtr ObjList::GetAt(int index)
{
    register ObjLink *l;
    register int i= 0;

    for(i= 0, l= first; l; l= l->next) {
	if (!l->op->IsDeleted()) {
	    if (i == index)
		return l->op;
	    i++;
	}
    }
    return 0;
}

ObjPtr ObjList::AtBefore(ObjPtr before)
{
    register ObjLink *l;

    for (l = first; l; l= l->next) {
	if (l->op->IsEqual(before)) {
	    l = l->previous;
	    if (l == 0)
		return 0;
	    return l->op;
	}
    }    
    if (l == 0)
	Error ("AtBefore", "object not found");
}

ObjPtr ObjList::AtAfter(ObjPtr after)
{
    register ObjLink *l;

    for (l = first; l; l= l->next) {
	if (l->op->IsEqual(after)) {
	    l= l->next;
	    if (l == 0) 
		return 0;
	    return l->op;
	}
    }
    if (l == 0)
	Error ("AtAfter", "object not found");
}

void ObjList::Empty(int)
{
    CheckActiveIter("Empty");
    RemoveAll(this);
}

ObjPtr ObjList::At(int i)
{
    return GetAt(i);
}

Iterator *ObjList::GetIterator() 
{ 
    return new ObjListIter(this); 
}

Iterator *ObjList::ReversedIterator () 
{ 
    return new RevObjListIter(this); 
}

//---- ObjListIter -------------------------------------------------------------

FIXED_STORAGE(ObjListIter, 20);

ObjListIter::ObjListIter(Collection *s)
{
    FIXED_SIZE_ALLOC(ObjListIter);
    cs= (ObjList*)s; 
    ce= cs ? cs->first : 0; 
}

ObjListIter::~ObjListIter()
{
    IteratorEnd();
    FIXED_SIZE_DEALLOC(ObjListIter);
}

void ObjListIter::Reset(Collection *s)
{
    if (s == 0)
	s= Coll();
    cs= (ObjList*)s;
    ce= cs ? cs->first : 0;
    Iterator::Reset(s);
}

Collection *ObjListIter::Coll()
{
    return cs;
}

Object* ObjListIter::operator()()
{
    Object *op;

    if (cs == 0)
	return 0;
    IteratorStart();

    while (ce && ce->op->IsDeleted())
	ce= ce->next;

    if (ce) {
	op= ce->op;
	ce= ce->next;
	return op;
    }
    ce= cs->first;
    IteratorEnd();
    return 0;
}

//---- RevObjListIter ----------------------------------------------------------

RevObjListIter::RevObjListIter(ObjList *s) : (s)
{ 
    cs= (ObjList*)s; 
    ce= cs ? cs->last : 0;
}

void RevObjListIter::Reset(Collection *s)
{
    ObjListIter::Reset(s);
    ce= cs ? cs->last : 0;
}

Object* RevObjListIter::operator()()
{
    Object *op;

    if (cs == 0)
	return 0;
    IteratorStart();

    while (ce && ce->op->IsDeleted())
	ce= ce->previous;

    if (ce) {
	op= ce->op;
	ce= ce->previous;
	return op;
    }
    ce= cs->last;
    IteratorEnd();
    return 0;
}

ONEXIT(ObjList)
{
    PrintStorageStatistics();
    PrintFixedStorageStatistics();
}
