#ifndef ObjArray_First
#define ObjArray_First

#include "Collection.h"

extern char *cOutOfBoundsError;
extern char *cMethodName;

//---- class ObjArray --------------------------------------------------

class ObjArray: public Collection {
friend class ObjArrayIter;
friend class OrdCollection;
    ObjPtr *cont;
    int  lb; // lower bound of the array
    bool BoundsOk(char *where, int at)
	{ if ( at < lb || at-lb >= size) {
	    Error(where, cOutOfBoundsError, at, Size(), this);
	    return FALSE;
	  }
	  else
	    return TRUE;
	}        
public:  
    MetaDef(ObjArray);

    //---- creation, destruction  
    ObjArray(int s= cCollectionInitCap, int lowerBound= 0); 
    ~ObjArray();
    void InitNew();              
    void Expand (int);              // expand or shrink an array
    ObjPtr Add(ObjPtr);
    void FreeAll();

    //---- accessing
    Iterator *GetIterator();           // return a Iterator iterator of a collection
    bool Contains (ObjPtr);         
    bool ContainsPtr (ObjPtr);         
    int ContainsPtrAt (ObjPtr);     // returns -1 if not found     
    int ContainsAt (ObjPtr);        //        "           "
    ObjPtr At(int i);
    ObjPtr AtPut(int i, ObjPtr op);
    void AtPutAndExpand(int i, ObjPtr op);// expands the array if necessary
    ObjPtr& operator[](int i)       // shorthand notation
	{ 
	    if ( i < lb || i-lb >= size)
		Error(cMethodName, cOutOfBoundsError);
	    return cont[i-lb]; 
	}
    ObjPtr UncheckedAt(int i)
	{ return cont[i]; }
    ObjPtr RemoveAt(int i);   
    ObjPtr Remove(ObjPtr a);
    ObjPtr RemovePtr(ObjPtr a);
    int LowerBound()
	{ return lb; }
    void Sort(int upto = cMaxInt);
    int BinarySearch(ObjPtr, int upto = cMaxInt);
	// the ObjArray has to be sorted, -1 == not found !!

    //---- comparing   
    int Hash ();
    bool IsEqual (ObjPtr);
    int  Compare (ObjPtr);

    //---- activation/passivation
    ostream& PrintOn(ostream&s);
    istream& ReadFrom(istream&s);
};

class ObjArrayIter: public Iterator {
    int ce;
    ObjArray *cs;
public:
    ObjArrayIter(Collection *s);
    ~ObjArrayIter();
    void Reset(Collection *c= 0);
    ObjPtr operator()();
    virtual bool Filter(ObjPtr);
};

#endif ObjArray_First
