//$NeWSWindowSystem,NeWSEvtHandler$
#include "NeWSWindowSystem.h"

#include "NeWSWindowPort.h"
#include "NeWSFont.h"
#include "NeWSBitmap.h"

#include "../String.h"
#include <sgtty.h>

#include "psio.h"
#include "news.h"
#undef ps_flush_PostScript
#define ps_flush_PostScript() psio_flush(PostScript)

extern int ioctl(int,int,void*);

//---- NeWSEvtHandler -------------------------------------------------------------

extern NeWSWindowPort *wports[];

class NeWSEvtHandler : public SysEvtHandler {
public:
    NeWSEvtHandler(int fd) : (fd)
	{ }
    void Notify(SysEventCodes, int);
    bool HasInterest();
};

bool NeWSEvtHandler::HasInterest()
{
    ps_flush_PostScript();
    return ! ShouldRemove();
}

int lastwinid= -1;

void NeWSEvtHandler::Notify(SysEventCodes, int)
{
    int n, arg, id, code, flags, x, y, w, h;
    Token t;
    register NeWSWindowPort *port;    
    
    for (;;) {
	if (ps_getevent(&id, &code, &flags, &t.At, &x, &y, &w, &h)) {
	    if (id != lastwinid) {
		ps_focus(id);
		lastwinid= id;
	    }
	    port= wports[id];
	    if (port) {
		t.Code= code;
		t.Flags= flags;
		t.Pos.x= x;
		t.Pos.y= y;
		t.ext.x= w;
		t.ext.y= h;
		port->Send(&t);
	    }
	}
	n= psio_availinputbytes(PostScriptInput);
	if (n < 3)
	    break;
	ioctl(psio_fileno(PostScriptInput), FIONREAD, &arg);
	if (n+arg < 3)
	    break;
    }
    ps_flush_PostScript();
}

//---- NeWSWindowSystem -----------------------------------------------------------

WindowSystem *NewNeWSWindowSystem()
{
    WindowSystem *s= new NeWSWindowSystem();
    if (s->Open())
	return s;
    delete s;
    return 0;
}

NeWSWindowSystem::NeWSWindowSystem() : ("SunNeWS")
{
}
    
bool NeWSWindowSystem::Open()
{
    if (ps_open_PostScript() == NULL)
	return FALSE;

    if (! WindowSystem::Open())
	return FALSE;       
	
    gSystem->AddFileInputHandler(new NeWSEvtHandler(psio_fileno(PostScriptInput)));
    
    ps_initialize();    // load routines
    
    return TRUE;
}

void NeWSWindowSystem::MakeWindow(WindowPort **wp, InpHandlerFun ihf,
			    void *priv1, void *priv2, bool overlay, bool block)
{
    *wp= new NeWSWindowPort(ihf, priv1, priv2, overlay, block);
}

FontManager *NeWSWindowSystem::MakeFontManager(char *name)
{
    return new NeWSFontManager(name);
}

void NeWSWindowSystem::MakeBitmap(Bitmap **bp, Point sz, short *data)
{
    *bp= new NeWSBitmap(sz, data);
}

void NeWSWindowSystem::MakeBitmap(Bitmap **bp, const char *name)
{
    *bp= new NeWSBitmap(name);
}

void NeWSWindowSystem::graphicDelay(unsigned int duration)
{
    Wait(duration);
}
