#include "Metric.h"
#include "Class.h"


static Class MetricClassMetaImpl0("Metric",
				  sizeof (Metric),
				  0,
				  __FILE__,
				  "./Metric.h",
				  __LINE__,
				  1,
				  __COMPILEDIR__,
				  __COMPILEDIR__);


Metric::Metric()
{
    extent.x= extent.y= base= 0;
}

Metric::Metric(Point e, short b)
{
    extent= e;
    base= b;
}

Metric::Metric(Point e)
{
    extent= e;
    base= extent.y;
}

Metric::Metric(int w)
{
    extent.x= extent.y= w;
    base= w;
}

Metric::Metric(int w, int h)
{
    extent.x= w;
    base= extent.y= h;
}
    
Metric::Metric(int w, int h, int b)
{
    extent.x= w;
    extent.y= h;
    base= b;
}

Metric Metric::Inset(Point e)
{
    extent-= 2*e;
    base-= e.y;
    return *this;
}

Metric Metric::Expand(Point e)
{
    extent+= 2*e;
    base+= e.y;
    return *this;
}

Metric Metric::Merge(Metric m)
{
    extent.x= max(extent.x, m.extent.x);
    base= max(base, m.base);
    int descender= max(extent.y-base, m.extent.y-m.base);
    extent.y= base+descender;
    return *this;
}

Metric HCat(Metric m1, Metric m2, int hgap)
{
    Metric m;
    m.extent.x= m1.extent.x + m2.extent.x + hgap;
    m.base= max(m1.base, m2.base);
    int descender= max(m1.extent.y-m1.base, m2.extent.y-m2.base);
    m.extent.y= m.base+descender;
    return m;
}

Metric VCat(Metric m1, Metric m2, int vgap)
{
    Metric m;
    m.extent.x= max(m1.extent.x, m2.extent.x);
    m.extent.y= m1.extent.y + m2.extent.y + vgap;
    m.base= m.extent.y/2;
    return m;
}

Metric Min(Metric m1, Metric m2)
{
    Metric m;
    m.extent.x= min(m1.extent.x, m2.extent.x);
    m.base= min(m1.base, m2.base);
    int descender= min(m1.extent.y-m1.base, m2.extent.y-m2.base);
    m.extent.y= descender+m.base;
    return m;
}

Metric Max(Metric m1, Metric m2)
{
    Metric m;
    m.extent.x= max(m1.extent.x, m2.extent.x);
    m.base= max(m1.base, m2.base);
    int descender= max(m1.extent.y-m1.base, m2.extent.y-m2.base);
    m.extent.y= descender+m.base;
    return m;
}     

