#ifndef Menu_First
#define Menu_First

#include "CollectionView.h"
#include "DialogItems.h"
#include <stdarg.h>

//---- MenuItem ----------------------------------------------------------------

class MenuItem : public Cluster {
    class Menu *nextMenu;
    short subid, lastxpos, enterxpos;
public:
    MetaDef(MenuItem);
    MenuItem(int id= cIdNone, VObject *v= 0, class Menu *nm= 0);
    ~MenuItem();

    Menu *ContMenu()
	{ return nextMenu; }
    void Enable(bool b= TRUE, bool redraw= TRUE);
    VObject *Detect(BoolFun find, void *arg);
    void *Hit();
    virtual void DoOnItem(int, Point);
    ostream& PrintOn (ostream&);
    istream& ReadFrom(istream&);
};

//---- MenuLineItem -----------------------------------------------------------------

class MenuLineItem : public LineItem {
public:
    MetaDef(MenuLineItem);
    MenuLineItem();
    void Enable(bool, bool);
};

//---- Menu --------------------------------------------------------------------

enum MenuOptions {
    eMenuTitle      = BIT(eCVLast+1),       // show title
    eMenuIsNew      = BIT(eCVLast+2),
    eMenuDelTitle   = BIT(eCVLast+3),
    eMenuNoScroll   = BIT(eCVLast+4),
    eMenuDefault    = eMenuTitle,
    eMenuLast       = eCVLast + 4
};

class Menu : public CollectionView {
    static int level;
    VObject *title;
    int selection;
protected:
    Point theItem;
    class BlankWin *window;
    class Clipper *clipper;

public:
    MetaDef(Menu);
    Menu(char *t, bool s= FALSE, int r= 0, int c= 1, bool st= TRUE);
    Menu(VObject *t, bool s= FALSE, int r= 0, int c= 1, bool st= TRUE);
    ~Menu();

    //---- initialize
    void Init(VObject *t, bool s, bool st);

    //---- misc
    bool IsNew()
	{ return TestFlag(eMenuIsNew); }
    VObject *GetTitle()
	{ return title; }
    void Update();
    void InspectorId(char *buf, int sz);

    //---- show/hide
    virtual int Show(Point, VObject *v= 0);
    virtual Point InitialPos();
    void Close();

    //---- submenues
    void AppendMenu(Menu*, int id= 999);

    //---- inserting items
    void Insert(VObject*);
    void InsertBefore(int id, VObject*);
    void InsertAfter(int id, VObject*);
    void InsertItemBefore(int atId, char *, int myId);
    void InsertItemAfter(int atId, char *, int myId);
    void InsertItemsBefore(int atId, char *s, ...);
    void InsertItemsAfter(int atId, char *s, ...);
    void InsertItem(char*, int);
    void InsertVItems(int atId, bool before, va_list ap);
    VObject *MakeMenuItem(char *s, int id);

    //---- adding items
    void Append(VObject*);
    void AppendItem(char*, int);
    void AppendItems(char *s, ...);

    //---- replace items
    void ReplaceItem(int, char*);

    //---- enable/disable items
    void EnableItem(int, bool b= TRUE);
    void EnableItems(int i1, int i2, ...);
    void DisableAll();
    void DisableItem(int id)
	{ EnableItem(id, FALSE); }

    //---- set selected item
    void SetSelectedItem(int);
    void SetSelectedItem(Point);

    //---- handling input
    void DoSelect(Rectangle);
    void DoOnItem(int, VObject *gop, Point);

    //---- find items
    VObject *Detect(BoolFun find, void *arg);
    Menu *FindMenuItem(int);

    //---- input/output
    ostream& PrintOn (ostream&);
    istream& ReadFrom(istream&);
};

#endif Menu_First
