//$FixedSizeStorage$

#include "FixedSizeStorage.h"
#include "String.h"
#include "ObjectTable.h"

struct FreeNode {
    class FreeNode *next;
};

struct Chunk {
    struct Chunk *next;
    char *storage;    
};

static FixedSizeStorage *allocators= 0;

//---- class FixedSizeStorage ----------------------------------------------

FixedSizeStorage::FixedSizeStorage(int osize, bool isobj, char *cl, int cs, bool dostat)
{
    // link instances of FixedSizeStorage
    next= allocators;
    allocators= this;

    objSize= osize;
    // chunkSize= (cs / objSize) * objSize;
    chunkSize= cs * objSize;
    objPerChunk= chunkSize / objSize;
    chunks= 0;
    lastIndex= objPerChunk; // force allocation of a new chunk
    freeList= 0;
    classname= cl;
    nchunks= allocated= recycled= freed= 0;
    isObject= isobj;
    stat= dostat;
}

FixedSizeStorage::~FixedSizeStorage()
{
    Chunk *p, *lp;

    for (p= chunks; p; p= lp) {
	delete p->storage;
	lp= p->next;
	delete p;
    }
}

void *FixedSizeStorage::Alloc()
{
    allocated++;
    if (freeList) {
	recycled++;
	FreeNode *tmp= freeList;
	freeList= freeList->next;
	return (void*)tmp;
    }
    if (lastIndex >= objPerChunk) { // need new chunk
	nchunks++;
	Chunk *cp;
	cp= new Chunk;
	cp->next= chunks;
	chunks= cp;
	chunks->storage= new char[chunkSize];
	lastIndex= 0;
    }
    return (void*)&chunks->storage[lastIndex++*objSize];
}

bool FixedSizeStorage::Dealloc(void *op)
{
    if (isObject) {
	Object *objptr= (Object*)op;
	ObjectTableRemove(objptr);
    }
    for (Chunk *p= chunks; p; p= p->next) {
	if (op >= p->storage && op <  p->storage + chunkSize) {
	    bzero((byte*)op, objSize);
	    FreeNode *fn= (FreeNode*)op;
	    fn->next= freeList;
	    freeList= fn;
	    freed++;
	    return TRUE;    
	}
    }
    return FALSE;  
}

void PrintFixedStorageStatistics()
{
    if (! gMemStatistics)
	return;
    fprintf(stderr, "\n");
    fprintf(stderr, "FixedSizeStorage Allocator\n");
    fprintf(stderr, "--------------------------\n");
    fprintf(stderr, "%-20s%8s%8s%8s%8s\n", "Class","alloc","recycl","freed",
								    "chunks");
    FixedSizeStorage *fsp;
    for (fsp= allocators; fsp; fsp= fsp->next) {
	if (fsp->stat || TRUE)
	    if (fsp->classname)
		fprintf(stderr,"%-20s%8d%8d%8d%8d\n", 
				    fsp->classname, fsp->allocated, 
				    fsp->recycled, fsp->freed, fsp->nchunks);
	    else
		fprintf(stderr,"%-10s%8d%8d%8d%8d\n", "Size of Objects",
				    fsp->objSize, fsp->allocated, 
				    fsp->recycled, fsp->freed, fsp->nchunks);
    }
}

