#ifndef FileType_First
#define FileType_First

#include "Root.h"
#include "Types.h"

//---- file types ---------------------------------------------------------

extern char *cMagic,             // magic cookie of ET++ generated files
	    *cDocTypeUndef,      // "UNDEF" document type
	    *cDocTypePict,       // "PICT" document type
	    *cDocTypeAscii,      // document type for ordinary ascii-files
	    *cDocTypePostScript, // PostScript document type
	    *cDocTypeDirectory,  // System directory
	    *cDocTypeSpecial,    // System special file
	    *cDocCreatorUndef,   // Creator of document unknown
	    *cDocSunRasterFile;  // Sun raster file format

//---- abstract class FileType --------------------------------------------

class FileType : public Root {
protected:
    char *pathname;
    char *typename;
    char *creator;
    bool isSystem, isAscii, isETFormat;

    
    void WhatType();
    virtual bool SystemFileType();
    virtual bool NotAsciiFileType();
public:
    FileType(char *pathName);
    virtual ~FileType();
    virtual char *Type();
    virtual char *Creator();  // returns 0 if not an ET++ created file
    virtual long SizeHint();  // -1 indicates no size hint
    virtual char *FileName();
    virtual int UniqueId();
    virtual bool IsCCode();
    virtual bool IsAscii();
    virtual bool IsSystem();
    virtual bool IsExecutable();
    virtual bool IsETFormat();
    char *PathName();
};

//---- class FType -----------------------------------------------------------
// some syntactic sugar -> uses destructors to free a dynamically allocated
// instance of FileType

class FType {
    class FileType *ft;
public:
    FType(char *pathName);
    ~FType()
	{ SafeDelete(ft); }
    char *Type()
	{ return ft->Type(); }
    FileType *FileType()
	{ return ft; }
    char *Creator()
	{ return ft->Creator(); }
    long SizeHint()
	{ return ft->SizeHint(); }
    char *FileName()
	{ return ft->FileName(); }
    int UniqueId()
	{ return ft->UniqueId(); }
    bool IsCCode()
	{ return ft->IsCCode(); }
    bool IsAscii()
	{ return ft->IsAscii(); }
    bool IsSystem()
	{ return ft->IsSystem(); }
    bool IsExecutable()
	{ return ft->IsExecutable(); }
    bool IsETFormat()
	{ return ft->IsETFormat(); }
    char *PathName()
	{ return ft->PathName(); }
};

#endif FileType_First

