#ifndef FileDialog_First
#define FileDialog_First

#include "Dialog.h"

//---- class Path ------------------------------------------------------------

class Path {    // pathname scanner
    char *path;
    char *p;
public:
    Path();
    ~Path();
    char *operator()();
    const char *GetPath();
    void Reset();
    void Start();
    char *At(int);
    char *Last();
    int Components();
};

//---- FileDialog --------------------------------------------------------------

const int cMaxPathName= 400;

enum FileDialogFlags {
    eFDRead,
    eFDWrite,
    eFDImport
};

class FileDialog : public Dialog {
protected:
    class CompositeVObject *scroller;
    class EditTextItem *eti;
    class TextItem *title, *workingDir, *dir;
    char *pathname, *initDir;
    FileDialogFlags flags;
    class CollectionView *collview;
    class OrdCollection *mylist;
    EvtHandler *doc;
    class FileType *doctype;
    class PathMenu *pathMenu;
    Path path;
    VObject *pathItem;

protected:
    void Control(int id, int, void *v);
    Command *DispatchEvents(Point lp, Token t, Clipper*);
    void UpdateList();
    void UpdatePath();
    void UpdateDir();
    bool OpenOrChangeDir();

public:
    MetaDef(FileDialog);
    
    FileDialog();
    ~FileDialog();
    
    int ShowInWindow(FileDialogFlags, Clipper*, EvtHandler *eh= 0);
    char *FileName()
	{ return pathname; }
    class FileType *GetDocType()
	{ return doctype; }
    virtual bool NotWritable(char *name);
    virtual bool NotReadable(char *name);
    virtual bool WrongType();
    virtual bool ChangeDirectory();
    
    VObject *DoCreateDialog();
    void DoSetup();
    
    //---- Hooks
    virtual VObject *Hook(FileDialogFlags);
    virtual int GetSaveOption();
};

#endif FileDialog_First

