#ifndef EvtHandler_First
#define EvtHandler_First

#include "Object.h"
#include "Port.h"

enum EvtFlags {
    eEvtDefault = eObjDefault,
    eEvtLast    = eObjLast + 0
};

class EvtHandler: public Object {
public:
    MetaDef(EvtHandler);
    
    EvtHandler();

    virtual EvtHandler *GetNextHandler();  
    virtual Point ContainerPoint(Point);
    
    virtual class Menu *GetMenu();
    virtual void DoSetupMenu(class Menu*);
    virtual void DoCreateMenu(class Menu*);
    virtual class Command *DoMenuCommand(int);
    virtual void PerformCommand(Command *);
    
    virtual Command *DoLeftButtonDownCommand(Point, Token, int);
    virtual Command *DoMiddleButtonDownCommand(Point, Token, int);
    virtual Command *DoRightButtonDownCommand(Point, Token, int, class Clipper*);
    
    virtual Command *DoKeyCommand(int, Point, Token);
    virtual Command *DoCursorKeyCommand(EvtCursorDir, Point, Token);
    virtual Command *DoFunctionKeyCommand(int, Point, Token);
    
    virtual Command *DoOtherEventCommand(Point, Token);
    virtual Command *DoIdleCommand();
    virtual void Control(int id, int part, void *val);
    virtual void DownControl(int id, int part, void *val);
    virtual Command *DispatchEvents(Point, Token, Clipper*);
    virtual Command *TrackInContent(Point, Token, Command*);
};

#endif EvtHandler_First

