//$Command$
#include "Command.h"
#include "Error.h"
#include "String.h"
#include "Port.h"
#include "ObjectTable.h"

MetaImpl(Command, (I_I(CmdNumber), I_CS(CmdName)));

static Command NoChanges(0);
static Command ResetUndo(0,"",eCmdCausesChange);

Command *gNoChanges= &NoChanges;
Command *gResetUndo= &ResetUndo;

Command::Command(int itsCmdNumber, char *itsCmdName, CommandFlags cf) : (cf)
{
    CmdNumber= itsCmdNumber;
    CmdName= itsCmdName;
}

Command::~Command()
{ 
    if (this == gNoChanges || this == gResetUndo || !TestFlag(eCmdDoDelete)) 
	this= 0;
}

void Command::Commit()
{
}

void Command::DoIt()
{
}

void Command::RedoIt()
{
    DoIt();
}

void Command::UndoIt()
{
}

void Command::Done(Command *newCmd)
{
}

void Command::TrackConstrain(Point, Point, Point *)
{
}

void Command::TrackFeedback(Point anchorPoint, Point nextpoint, bool)
{
    GrStrokeRect(NormRect(anchorPoint, nextpoint));
}

Command *Command::TrackMouse(TrackPhase, Point, Point, Point)
{
    ResetFlag(eCmdMoveEvents);
    return this;
}

void Command::Finish(Command *cmd)
{
    if (this && this != gNoChanges && this != gResetUndo) {
	if (TestFlag(eCmdDone))
	    Commit();
	Done(cmd);
	if (TestFlag(eCmdDoDelete))
	    delete this;
    }
}

void Command::Undo(int *changecount)
{
    if (TestFlag(eCmdDone)) {
	UndoIt();
	if (changecount)
	    (*changecount)--;
    } else {
	RedoIt();
	if (changecount)
	    (*changecount)++;
    }
    InvertFlag(eCmdDone);
}

char *Command::GetUndoName()
{     
    static char buf[30];
    char *s;

    if (TestFlag(eCmdDone)) {
	if (TestFlag(eCmdCanUndo))
	    s= "undo";
	else
	    s= "can't undo";
    } else
	s= "redo";
    strcpy(buf, s);
    if (GetName() && *GetName() != '\0') {
	strcat(buf, " ");
	strcat(buf, GetName());
    }
    return buf;
}

void Perform(Command* cmd, Command **lastCmd, int *cnt)
{
    // don't do anything on gNoChanges!!
    if (cmd && (cmd != gNoChanges) && (cmd->CmdNumber || cmd == gResetUndo)) {
	if (lastCmd)
	    (*lastCmd)->Finish(cmd);
	if (cmd != gResetUndo) {
	    cmd->DoIt();
	    if (cnt && cmd->TestFlag(eCmdCausesChange))
		(*cnt)++;
	    cmd->SetFlag(eCmdDone);
	}
	if (lastCmd)
	    *lastCmd= cmd;
	else
	    cmd->Finish(0);
    }
}

void Command::InspectorId(char *buf, int sz)
{
    if (GetName())
	strn0cpy(buf, GetName(), sz);
    else
	Object::InspectorId(buf, sz);
}

ONENTRY(Command)
{
    ObjectTableAddRoots(&NoChanges, &ResetUndo, 0);
}

