#ifndef ByteArray_First
#define ByteArray_First

#include "Object.h"

//---- class ByteArray ---------------------------------------------------------
extern char *cAtPutName;
extern char *cOutOfBoundsError;

class ByteArray: public Object {
    byte *cont;
    int  cap;
public:
    MetaDef(ByteArray);

    //---- creation, destruction  
    ByteArray(int size);              
    ByteArray(byte *aStr, int l= -1);               
    ~ByteArray();

    //---- accessing
    byte *Str ()
	{ return cont; }
    void SetString (byte *s); 
    void operator= (byte *s);
    char At(int i)
	{ return cont[i]; }
    void AtPut(int i, byte c)
	{ if ( i < 0 || i >= cap)
	    Error (cAtPutName, cOutOfBoundsError);
	  else
	    cont[i] = c; 
	}

    //---- standard overriden methods   
    int Hash ();
    bool IsEqual (ObjPtr);
    int  Compare (ObjPtr);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom (istream& s);
};

#endif ByteArray_First
