#ifndef BorderItems_First
#define BorderItems_First

#include "VObject.h"
#include "CmdNo.h"

//---- AbstractBorderItem ------------------------------------------------------

class AbstractBorderItem: public CompositeVObject {
protected:
    Point interiorOffset, extentDiff, border;
    VObject *interior, *titleBar;
    short lineWidth, titleGap, shadowWidth;
    
public:
    MetaDef(AbstractBorderItem);
    
    AbstractBorderItem(VObject *title, VObject *inner, int lw= 1, int id= cIdNone);
    AbstractBorderItem(char *title, VObject *inner, int lw= 1, int id= cIdNone);

    VObject* GetTitleBar()
	{ return titleBar; }
    VObject *GetInterior()
	{ return interior; }
    Point GetInteriorOffset()
	{ return interiorOffset; }

    void SetTitle(char *itsTitle, bool redraw);
    char *GetTitle();
    void SetOrigin(Point at);
    void SetExtent(Point e);
    Metric GetMinSize();
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
    void InspectorId(char *buf, int sz);
};

//---- ShadowBorderItem --------------------------------------------------------

class ShadowBorderItem: public AbstractBorderItem {
public:
    MetaDef(ShadowBorderItem);
    
    ShadowBorderItem(VObject *title, VObject *inner, int shadow= 5);
    ShadowBorderItem(char *title, VObject *inner, int shadow= 5);
    ShadowBorderItem(VObject *inner, int shadow= 5);
    
    void DrawBackground(Rectangle);
    void DrawForeground(Rectangle);
};

//---- WindowBorderItem --------------------------------------------------------

class WindowBorderItem: public AbstractBorderItem {
    bool fixed;
public:
    MetaDef(WindowBorderItem);
    
    WindowBorderItem(bool fixed, VObject *title, VObject *inner);
    
    void DrawBackground(Rectangle);
    Command *DoLeftButtonDownCommand(Point p, Token, int);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- BorderItem --------------------------------------------------------------

class BorderItem: public AbstractBorderItem {
    VObjAlign titleAlign;
public:
    MetaDef(BorderItem);
    BorderItem(VObject *inner, Point b= gBorder, int lw= 1, VObjAlign a= eVObjHLeft);
    BorderItem(VObject *title, VObject *inner, Point b= gBorder, int lw= 1, VObjAlign a= eVObjHLeft);
    BorderItem(char *title, VObject *inner, Point b= gBorder, int lw= 1, VObjAlign a= eVObjHLeft);
    BorderItem(int id, char *title, VObject *inner, Point b= gBorder, int lw= 1, VObjAlign a= eVObjHLeft);

    void SetOrigin(Point at);
    void SetExtent(Point e);
    int Base();
    Metric GetMinSize();
    void DrawBackground(Rectangle r);
    ostream& PrintOn(ostream&s);
    istream& ReadFrom(istream &);
};

#endif BorderItems_First

