#ifndef Alert_First
#define Alert_First

#include "Dialog.h"

enum AlertType {
    eAlertNote,         // OK-Button
    eAlertCaution,      // Yes, Cancel and No-Button
    eAlertStop,         // Yes, Cancel and No-Button
    eAlertMessage,      // OK-Button, no image
    eAlertSun,          // OK-Button, Sun-Logo
    eAlertError         // image only
};

class Alert: public Dialog {
    VObject *text, *image, *buttons;
public:
    MetaDef(Alert);

    Alert(AlertType= eAlertNote, char *text= 0, char *bn= 0, ...);
    ~Alert();

    VObject *DoCreateDialog();
    int Show(char*, ...);
    class Menu *GetMenu();
    void InspectorId(char *buf, int sz);
};

extern Alert NoteAlert;
extern Alert CautionAlert;
extern Alert StopAlert;
extern Alert MessageAlert;
extern Alert SunAlert;
extern Alert ErrorAlert;

extern bool TestInterrupt(char *what);

#endif Alert_First
