//$Alert$
#include "Alert.h"
#include "DialogItems.h"
#include "CheapText.h"
#include "StyledText.h"
#include "StaticTextView.h"
#include "ObjList.h"
#include "WindowSystem.h"
#include "BlankWin.h"
#include "ObjectTable.h"
#include "WindowSystem.h"


static short NoteBits[]= {
#   include "images/note.image"
};

static short CautionBits[]= {
#   include "images/caution.image"
};

static short StopBits[]= {
#   include "images/stop.image"
};

static short SunBits[]= {
#   include "images/sun.image"
};

static short ErrorBits[]= {
#   include "images/error.image"
};

static StaticBitmap Note(Point(64, 52), NoteBits),
		    Caution(Point(64, 52), CautionBits),
		    Stop(64, StopBits),
		    Sun(64, SunBits),
		    ErrorBitMap(64, ErrorBits);

Alert NoteAlert(eAlertNote, "note", "OK", cIdOk, 0);

Alert CautionAlert(eAlertCaution, "Caution", "Yes",    cIdYes,
					     "No",     cIdNo,
					     "Cancel", cIdCancel, 0);

Alert StopAlert(eAlertStop, "Stop", "Yes",    cIdYes,
				    "No",     cIdNo,
				    "Cancel", cIdCancel, 0);

Alert MessageAlert(eAlertMessage, "Message", "Ok", cIdOk, 0);

Alert SunAlert(eAlertSun, "Message", "Ok", cIdOk, 0);
 
Alert ErrorAlert(eAlertError, "Error", "Ignore",              cIdIgnore,
				      "Abort with Core",     cIdAbort,
				      "Inspect",             cIdInspect, 
				      "Trace",               cIdTrace, 0);

MetaImpl(Alert, (I_O(text), I_O(image), I_O(buttons)));

Alert::Alert(AlertType at, char *message, char *, ...)
						: (0, eBWinOverlay+eBWinBlock)
{
    va_list ap;
    ObjList *ol;

    if (message == 0)
	return;

    text= new StaticTextView((View*)0, Rectangle(gSysFont->Width('n')*40,cFit),
							new CheapText(message));
    switch (at) {
    case eAlertNote:
	image= new ImageItem(&Note);
	break;
    case eAlertCaution:
	image= new ImageItem(&Caution);
	break;
    case eAlertStop:
	image= new ImageItem(&Stop);
	break;
    case eAlertSun:
	image= new ImageItem(&Sun);
	break;
    case eAlertError:
	image= new ImageItem(&ErrorBitMap);
	break;
    case eAlertMessage:
	break;
    }

    if (at == eAlertMessage)
	image= text;
    else
	image= new Cluster(2, eVObjVTop, 25, image, text, 0);

    ol= new ObjList;
    buttons= new Cluster(2, eVObjVBase, 20, ol);

    va_start(ap, message);
    char *s;
    for (int i= 0; s= va_arg(ap, char*); i++)
	ol->Add(new ActionButton(va_arg(ap, int), s, i == 0));   
    va_end(ap);
}

Alert::~Alert()
{
    if (text) {
	Text *t= ((StaticTextView*)text)->GetText();
	SafeDelete(t);
	SafeDelete(text);
	this= 0;    // hack
    }
}

VObject *Alert::DoCreateDialog()
{
    return 
	new BorderItem(
	    new BorderItem(
		new Cluster(2, eVObjHLeft, gPoint10, image, buttons, 0),
		Point(15),
		3
	    ),
	    gPoint2,
	    1
	);

}

int Alert::Show(char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    int ret;

    if (image->IsKindOf(Cluster))
	((Cluster*)image)->SetModified();
    char *buf= strvprintf(fmt, ap);
    if (gWinInit) {
	delete ((StaticTextView*)text)->SetText(new StyledText(gSysFont, buf));
	// GetWindow()->contentRect.extent= gPoint0;
	CalcLayout(FALSE);
	ret= Dialog::Show();
    } else {
	cerr << buf NL;
	ret= cIdNo;
    }    
    va_end(ap);
    SafeDelete(buf);
    return ret;
}

class Menu *Alert::GetMenu()
{
    return 0;
}

void Alert::InspectorId(char *buf, int sz)
{
    if (text)
	text->InspectorId(buf, sz);
    else
	Dialog::InspectorId(buf, sz);   
}

bool TestInterrupt(char *what)
{
    if (Interrupted())
	return StopAlert.Show("Abort %s?", what) == cIdYes;
    return FALSE;
}

ONENTRY(Alert)
{
    ObjectTableAddRoots(&NoteAlert, &CautionAlert, &StopAlert, &MessageAlert, 
						    &SunAlert, &ErrorAlert, 0);
}
