//$vobedit$
#include "Application.h"
#include "Alert.h"
#include "VobEditDoc.h"
#include "String.h"

static char *aboutMsg= 
"An Example of a @IVObjectText@I. A VObjectText is a text that can \
integrate arbitrary instances of @IVObjects@I. Examples are @IActionButtons@I, \
@IRadioButtons@I and (recursively) another @ITextView@P.\n Even Clippers (@BMicky@P) \
can be integrated and behave as ordinary characters. Notice that the Mickyimage \
can @Iscroll@I independently of the rest of the text.";

//---- vobedit -----------------------------------------------------------------

class vobedit: public Application { 
public:
    MetaDef(vobedit);
    vobedit(int argc, char **argv) : (argc, argv, cVobDocType)
	{ }
    Document *DoMakeDocuments(char *)
	{ return new VobEditDoc; }
    bool CanOpenDocument(class FileType *);
    void About()
	{ NoteAlert.Show(aboutMsg); }
};

MetaImpl0(vobedit);

bool vobedit::CanOpenDocument(class FileType *ft)
{
    return strismember(ft->Type(), cVobDocType, cDocTypeAscii, 0);    
}

main(int argc, char *argv[])
{
    vobedit myAppl(argc, argv);    

    myAppl.Run();
}
