//$TwoViewDoc$
#include "ET++.h"

#include "CodeTextView.h"
#include "GapText.h"

#include "TwoViewDoc.h"

//---- TwoViewDoc ---------------------------------------------------------------

MetaImpl(TwoViewDoc, (I_O(view1), I_O(view2), I_O(text)));

TwoViewDoc::TwoViewDoc(): (cDocTypeAscii)
{
    text= new GapText("One text shown in two\nviews");
}

TwoViewDoc::~TwoViewDoc()
{
    SafeDelete(view1);
    SafeDelete(view2);
    SafeDelete(text);
}

Window *TwoViewDoc::DoMakeWindows()
{   
    view1= new TextView(this, Rectangle(Point(400,cFit)), text, eCenter);
    view2= new TextView(this, Rectangle(Point(1000,cFit)), text);
    
    return new Window(this, Point(700, 400), eBWinDefault,
	new Expander(eHor, gPoint2, 
	    new Scroller(view1),
	    new Splitter(view2),
	    0)
    );
}
 
void TwoViewDoc::DoRead(istream &s, FileType *ft)
{ 
    text->ReadFromAsPureText(s, ft->SizeHint());
    view1->SetText(text);
    view2->SetText(text);
}

void TwoViewDoc::DoWrite(ostream &s, int)
{ 
    text->PrintOnAsPureText(s);
}
