//$Shape,BoxShape,OvalShape,TextShape,PatternCommand,PatternMenuItem$
//$ShapeView,ShapeDocument,threeshapes$

#include "ET++.h"

#include "OrdCollection.h"
#include "TextView.h"
#include "GapText.h"
//#include "CheapText.h"
#include "Alert.h"


const int cPATTERNMENU  =   cUSERCMD,
	  cSETPATTERN   =   cUSERCMD + 100;

static char *aboutMsg= 
"Extended version of @Btwoshapes@P illustrating how to integrate text\n\
(resize shapes with @Icntl@P and @Ileft mouse button@P)";

//--- Shape --------------------------------------------------------------------

class Shape: public VObject { 
protected:
    GrPattern pattern;
public:
    MetaDef(Shape);
    
    Shape(View *vp, Rectangle r) : (vp, r)
	{ pattern= ePatWhite; }
    Metric GetMinSize()
	{ return Metric(20); }
    void Draw(Rectangle)
	{ GrSetPattern(pattern); }
    void SetPattern(GrPattern newpat);
    GrPattern GetPattern()
	{ return pattern; }
    Command *DoLeftButtonDownCommand(Point p, Token t, int cl);
    ostream &PrintOn(ostream &s);
    istream &ReadFrom(istream &s);
};

MetaImpl(Shape, I_I(pattern));

void Shape::SetPattern(GrPattern newpat) 
{
    pattern= newpat;
    ForceRedraw();
    Changed();
}

Command *Shape::DoLeftButtonDownCommand(Point, Token t, int)
{
    if (t.Flags & eFlgCntlKey)
	return GetStretcher();
    return GetMover();
}

ostream &Shape::PrintOn(ostream &s)
{
    VObject::PrintOn(s);
    return s << contentRect SP << pattern SP;
}

istream &Shape::ReadFrom(istream &s)
{
    VObject::ReadFrom(s);
    return s >> contentRect >> Enum(pattern);
}

//---- BoxShape --------------------------------------------------------

class BoxShape: public Shape {
public:
    MetaDef(BoxShape);
    BoxShape(View *vp, Rectangle r) : (vp, r)
	{ }
    void Draw(Rectangle r)
	{ Shape::Draw(r); GrFillRect(contentRect); GrStrokeRect(contentRect); }
};

MetaImpl0(BoxShape);

//---- OvalShape --------------------------------------------------------

class OvalShape: public Shape {
public:
    MetaDef(OvalShape);
    OvalShape(View *vp, Rectangle r) : (vp, r)
	{ }
    void Draw(Rectangle r)
	{ Shape::Draw(r); GrFillOval(contentRect); GrStrokeOval(contentRect); }
};

MetaImpl0(OvalShape);

//---- TextShape --------------------------------------------------------

class TextShape: public BoxShape {
    TextView *tv;
public:
    MetaDef(TextShape);
    TextShape(View*, Rectangle);
    ~TextShape()
	{ SafeDelete(tv); }

    void Init(Text*);
    void SetView(View *v);
    void SetOrigin(Point at);
    void SetExtent(Point e);
    Metric GetMinSize()
	{ return Metric(40, 10); }
    void Draw(Rectangle r);
    void DoUpdate(Object *op, void *what);
    TextView *GetTextView()
	{ return (TextView*) tv; }
    Command *DispatchEvents(Point p, Token t, Clipper *vf);
    ostream &PrintOn(ostream &s);
    istream &ReadFrom(istream &s);
};

MetaImpl(TextShape, I_O(tv));

TextShape::TextShape(View *vp, Rectangle r) : (vp, r)
{
    Init(new GapText("an_example_of_a_textshape"));
}

void TextShape::Init(Text *t)
{
    SafeDelete(tv);
    Rectangle rr= contentRect.Inset(4);
    rr.extent.y= cFit;
    tv= new TextView(this, rr, t);
    tv->AddDependent(this);     // register myself as dependent of a textview
    Shape::SetExtent(tv->GetExtent() + gPoint4*2);
    tv->SetView(GetView());
}

void TextShape::SetView(View *v)
{
    Shape::SetView(v);
    tv->SetView(v);
}

void TextShape::SetOrigin(Point at)
{
    Shape::SetOrigin(at);
    tv->SetOrigin(at+gPoint4);
}

void TextShape::SetExtent(Point e)
{
    tv->SetExtent(e-2*gPoint4);
}

void TextShape::Draw(Rectangle r)
{ 
    BoxShape::Draw(r);
    tv->DrawAll(r);
}

void TextShape::DoUpdate(Object *op, void *what)
{
    if (op == tv && ((int) what == eExtent || (int) what == eOrigin)) {
	ForceRedraw();
	contentRect= tv->ContentRect().Expand(4);
	ForceRedraw();
    }
}

Command *TextShape::DispatchEvents(Point p, Token t, Clipper *vf)
{
    Command *cmd= tv->VObject::Input(p, t, vf);
    if (cmd)
	return cmd;
    return Shape::DispatchEvents(p, t, vf);
}

ostream &TextShape::PrintOn(ostream &s)
{ 
    BoxShape::PrintOn(s);
    return s << tv->GetText() SP;
}

istream &TextShape::ReadFrom(istream &s)
{ 
    Text *t;
    BoxShape::ReadFrom(s);
    s >> t;
    Init(t);
    return s;
}

//---- PatternCommand --------------------------------------------------------

class PatternCommand: public Command {
    Shape *shape;
    GrPattern oldPattern, newPattern;
public:
    PatternCommand(Shape *s, GrPattern newpat);

    void DoIt()
	{ shape->SetPattern(newPattern); }
    void UndoIt()
	{ shape->SetPattern(oldPattern); }
};

PatternCommand::PatternCommand(Shape *s, GrPattern newpat)
						: (cSETPATTERN, "set pattern")
{
    shape= s; 
    newPattern= newpat; 
    oldPattern= shape->GetPattern();
}

//---- PatternMenuItem ---------------------------------------------------------

class PatternMenuItem : public VObject {
    GrPattern pat;
public:
    MetaDef(PatternMenuItem);
    PatternMenuItem(int id, GrPattern p) : (id)
	{ pat= p; SetExtent(Point(50, 20)); }
    void Draw(Rectangle)
	{ GrPaintRect(contentRect.Inset(3), pat); }
    void Highlight(HighlightState)
	{ GrSetPenSize(3); GrStrokeRect(contentRect); }
};

MetaImpl(PatternMenuItem, I_I(pat));

//---- ShapeView ---------------------------------------------------------

class ShapeView: public View {
    SeqCollection *list;
    Shape *selected;
    TextShape *textshape;
public:
    MetaDef(ShapeView);
    
    ShapeView(Document *d, Point ext);
    ~ShapeView();

    void Draw(Rectangle r)
	{ list->ForEach(Shape,DrawAll)(r); }
    Command *DispatchEvents(Point, Token, Clipper*);
    Command *DoMenuCommand(int);
    void DoCreateMenu(Menu*);
    void DoSetupMenu(Menu*);
    void SetShapes(SeqCollection *shapes);
    ostream &PrintOn(ostream &s)
	{ return s << list; }
    istream &ReadFrom(istream &);
};

MetaImpl(ShapeView, (I_O(list), I_O(selected), I_O(textshape)));

ShapeView::ShapeView(Document *d, Point ext) : (d, ext)
{   
    list= new OrdCollection;
    list->Add(new BoxShape(this, Rectangle(100,100,100,100))); 
    list->Add(new OvalShape(this, Rectangle(150,150,100,100)));
    list->Add(textshape= new TextShape(this, Rectangle(20,20,100,100)));
}

ShapeView::~ShapeView()
{
    if (list) {
	list->FreeAll();
	SafeDelete(list);
    }
}

Command *ShapeView::DispatchEvents(Point p, Token t, Clipper *vf)
{
    Iter next(list);
    Shape *s;
    
    selected= 0;
    while (s= (Shape*) next())
	if (s->ContainsPoint(p))
	    selected= s;
    if (selected) 
	return selected->Input(p, t, vf);
    return View::DispatchEvents(p, t, vf);
}

void ShapeView::SetShapes(SeqCollection *shapes) 
{
    if (list) {
	list->FreeAll();
	SafeDelete(list);
    } 
    list= shapes;
    Iter next(list);
    Shape *shape;
    
    while (shape= (Shape*) next()) {
	shape->SetView(this);
	shape->SetContainer(this);
	if (shape->IsKindOf(TextShape))
	    textshape= (TextShape*)shape;
    }   
}

istream &ShapeView::ReadFrom(istream &s)
{
    SeqCollection *newlist= 0;
    s >> newlist;
    SetShapes(newlist);
    ForceRedraw();
    return s;
}

void ShapeView::DoCreateMenu(Menu *menu)
{
    View::DoCreateMenu(menu);
    Menu *patterns= new Menu("patterns", FALSE, 4, 2);
    patterns->Append(new TextItem(cSETPATTERN+ePatNone, "none"));
    for (GrPattern p= ePatWhite; p <= ePatGrey12; p++)
	patterns->Append(new PatternMenuItem(cSETPATTERN+p, p));
    
    menu->AppendMenu(patterns, cPATTERNMENU);
    menu->Append(new TextItem(cABOUT, "about"));
}

void ShapeView::DoSetupMenu(Menu *menu)
{
    View::DoSetupMenu(menu);
    for (GrPattern p= ePatNone; p <= ePatGrey12; p++)
	menu->EnableItem(cSETPATTERN+p);
    if (! textshape->GetTextView()->Caret())
	menu->EnableItems(cCUT, cCOPY, 0);
    menu->EnableItems(cPATTERNMENU, cABOUT, cPASTE, 0);
}

Command *ShapeView::DoMenuCommand(int cmd)
{
    if (cmd >= cSETPATTERN+ePatNone && cmd <= cSETPATTERN+ePatGrey12 && selected)
	return new PatternCommand(selected, cmd-cSETPATTERN);
    if (cmd == cCUT || cmd == cCOPY || cmd == cPASTE)
	return textshape->GetTextView()->DoMenuCommand(cmd);
    return View::DoMenuCommand(cmd);
}

//---- ShapeDocument -----------------------------------------------------

char *cDocTypeShapes = "THREESHAPES";

class ShapeDocument: public Document {
    ShapeView *view;
public:
    MetaDef(ShapeDocument);
    ShapeDocument() : (cDocTypeShapes)
	{ }
    ~ShapeDocument()
	{ SafeDelete(view); }
    
    Window *DoMakeWindows();
    void DoWrite(ostream &s, int o)
	{ Document::DoWrite(s, o); view->PrintOn(s); }
    void DoRead(istream &s, FileType *ft)
	{ Document::DoRead(s, ft); view->ReadFrom(s); }
};

MetaImpl(ShapeDocument, I_O(view));

Window *ShapeDocument::DoMakeWindows()
{
    view= new ShapeView(this, Point(1000));
    return new Window(this, Point(400), eWinDefault, new Scroller(view));
}

//---- ShapeApplication --------------------------------------------------

class threeshapes: public Application {
public:
    threeshapes(int argc, char *argv[]) : (argc, argv, cDocTypeShapes)
	{ }
    Document *DoMakeDocuments(char *)
	{ return new ShapeDocument(); }
    void About()
	{ NoteAlert.Show(aboutMsg); }
};

//---- main --------------------------------------------------------------

main(int argc, char *argv[])
{
    threeshapes myapp(argc, argv);
    
    myapp.Run();
}          
